/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerRmTask
extends GenericDockerTask {
    private final Property<String> containerId;
    private final Property<Boolean> removeVolumes;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    @Optional
    public Property<Boolean> getRemoveVolumes() {
        return this.removeVolumes;
    }

    @Inject
    public DockerRmTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Remove one or more containers");
        this.containerId = objectFactory.property(String.class);
        this.removeVolumes = objectFactory.property(Boolean.class);
        this.removeVolumes.convention((Object)false);
    }

    @TaskAction
    public void rm() {
        this.getLogger().info("docker rm");
        HashMap<String, Integer> query = new HashMap<String, Integer>(1);
        query.put("v", (Boolean)this.getRemoveVolumes().get() != false ? 1 : 0);
        this.getDockerClient().rm((String)this.getContainerId().get(), query);
    }
}

