/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class DockerTagTask
extends GenericDockerTask {
    private final Property<String> imageId;
    private final Property<String> imageTag;

    @Input
    public Property<String> getImageId() {
        return this.imageId;
    }

    @Input
    public Property<String> getImageTag() {
        return this.imageTag;
    }

    @Inject
    public DockerTagTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Tag an image into a repository");
        this.imageId = objectFactory.property(String.class);
        this.imageTag = objectFactory.property(String.class);
    }

    @TaskAction
    public void tag() {
        this.getLogger().info("docker tag");
        this.getDockerClient().tag((String)this.getImageId().get(), (String)this.getImageTag().get());
    }
}

