/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.client.DockerClient;
import de.gesellix.docker.client.DockerClientImpl;
import de.gesellix.docker.engine.DockerEnv;
import java.net.Proxy;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class GenericDockerTask
extends DefaultTask {
    Property<String> dockerHost;
    Property<String> certPath;
    Property<Proxy> proxy;
    Property<AuthConfig> authConfig;
    private DockerClient dockerClient;

    @Input
    @Optional
    public Property<String> getDockerHost() {
        return this.dockerHost;
    }

    @Input
    @Optional
    public Property<String> getCertPath() {
        return this.certPath;
    }

    @Input
    @Optional
    public Property<Proxy> getProxy() {
        return this.proxy;
    }

    @Input
    @Optional
    public Property<AuthConfig> getAuthConfig() {
        return this.authConfig;
    }

    @Internal
    public String getEncodedAuthConfig() {
        return (String)this.authConfig.map(a -> this.getDockerClient().encodeAuthConfig(a)).getOrElse((Object)"");
    }

    void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }

    @Inject
    public GenericDockerTask(ObjectFactory objectFactory) {
        this.dockerHost = objectFactory.property(String.class);
        this.certPath = objectFactory.property(String.class);
        this.proxy = objectFactory.property(Proxy.class);
        this.authConfig = objectFactory.property(AuthConfig.class);
        this.setGroup("Docker");
    }

    @Internal
    public DockerClient getDockerClient() {
        if (this.dockerClient == null) {
            if (this.dockerHost.isPresent() || this.certPath.isPresent()) {
                DockerEnv dockerEnv = new DockerEnv();
                if (this.dockerHost.isPresent()) {
                    dockerEnv.setDockerHost((String)this.dockerHost.get());
                }
                if (this.certPath.isPresent()) {
                    dockerEnv.setCertPath(this.getProject().file(this.certPath.get()).getAbsolutePath());
                }
                this.dockerClient = new DockerClientImpl(dockerEnv, (Proxy)this.proxy.getOrElse((Object)Proxy.NO_PROXY));
            } else {
                this.dockerClient = new DockerClientImpl();
            }
        }
        return this.dockerClient;
    }
}

