/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class DockerNetworkConnectTask
extends GenericDockerTask {
    private final Property<String> networkName;
    private final Property<String> containerName;

    @Input
    public Property<String> getNetworkName() {
        return this.networkName;
    }

    @Input
    public Property<String> getContainerName() {
        return this.containerName;
    }

    @Inject
    public DockerNetworkConnectTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Connects a container to a network");
        this.networkName = objectFactory.property(String.class);
        this.containerName = objectFactory.property(String.class);
    }

    @TaskAction
    public void connectNetwork() {
        this.getLogger().info("docker network connect");
        this.getDockerClient().connectNetwork((String)this.getNetworkName().get(), (String)this.getContainerName().get());
    }
}

