/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.remote.api.NetworkCreateResponse;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class DockerNetworkCreateTask
extends GenericDockerTask {
    private final Property<String> networkName;
    private final MapProperty<String, Object> networkConfig;
    private EngineResponseContent<NetworkCreateResponse> response;

    @Input
    public Property<String> getNetworkName() {
        return this.networkName;
    }

    @Input
    public MapProperty<String, Object> getNetworkConfig() {
        return this.networkConfig;
    }

    @Internal
    public EngineResponseContent<NetworkCreateResponse> getResponse() {
        return this.response;
    }

    @Inject
    public DockerNetworkCreateTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Create a new network");
        this.networkName = objectFactory.property(String.class);
        this.networkConfig = objectFactory.mapProperty(String.class, Object.class);
    }

    @TaskAction
    public void createNetwork() {
        this.getLogger().info("docker network create");
        this.response = this.getDockerClient().createNetwork((String)this.getNetworkName().get(), new HashMap((Map)this.getNetworkConfig().getOrElse(new HashMap())));
    }
}

