/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerNetworkRmTask
extends GenericDockerTask {
    private final Property<String> networkName;
    private final Property<Boolean> ignoreError;

    @Input
    public Property<String> getNetworkName() {
        return this.networkName;
    }

    @Input
    @Optional
    public Property<Boolean> getIgnoreError() {
        return this.ignoreError;
    }

    @Inject
    public DockerNetworkRmTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Remove a network");
        this.networkName = objectFactory.property(String.class);
        this.ignoreError = objectFactory.property(Boolean.class);
        this.ignoreError.convention((Object)false);
    }

    @TaskAction
    public void rmNetwork() {
        this.getLogger().info("docker network rm");
        try {
            this.getDockerClient().rmNetwork((String)this.getNetworkName().get());
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreError.get()).booleanValue()) {
                throw new RuntimeException(e);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().warn("docker network rm " + (String)this.getNetworkName().get() + " failed", (Throwable)e);
            }
            this.getLogger().warn("docker network rm " + (String)this.getNetworkName().get() + " failed");
        }
    }
}

