/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.remote.api.CreateImageInfo;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerPullTask
extends GenericDockerTask {
    private final Property<String> imageName;
    private final Property<String> imageTag;
    private final Property<String> registry;
    private String imageId;
    public Duration pullTimeout = Duration.of(10L, ChronoUnit.MINUTES);

    @Input
    public Property<String> getImageName() {
        return this.imageName;
    }

    @Input
    @Optional
    public Property<String> getImageTag() {
        return this.imageTag;
    }

    @Input
    @Optional
    public Property<String> getRegistry() {
        return this.registry;
    }

    @Internal
    public String getImageId() {
        return this.imageId;
    }

    @Internal
    public Duration getPullTimeout() {
        return this.pullTimeout;
    }

    @Inject
    public DockerPullTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Pull an image or a repository from a Docker registry server");
        this.imageName = objectFactory.property(String.class);
        this.imageTag = objectFactory.property(String.class);
        this.registry = objectFactory.property(String.class);
    }

    @TaskAction
    public String pull() {
        this.getLogger().info("docker pull");
        String imageName = (String)this.getImageName().map(i -> (String)this.getRegistry().map(r -> r + "/" + i).getOrElse(i)).get();
        final ArrayList infos = new ArrayList();
        final CountDownLatch pullFinished = new CountDownLatch(1);
        this.getDockerClient().pull((StreamCallback)new StreamCallback<CreateImageInfo>(){

            public void onNext(CreateImageInfo element) {
                if (element != null) {
                    DockerPullTask.this.getLogger().info(element.toString());
                }
                infos.add(element);
            }

            public void onFailed(Exception e) {
                pullFinished.countDown();
            }

            public void onFinished() {
                pullFinished.countDown();
            }
        }, this.pullTimeout, imageName, (String)this.getImageTag().getOrNull(), this.getEncodedAuthConfig());
        try {
            pullFinished.await(this.pullTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new GradleException("Pull didn't finish before " + this.pullTimeout, (Throwable)e);
        }
        this.imageId = imageName + (String)this.getImageTag().map(t -> ":" + t).getOrElse((Object)"");
        return this.imageId;
    }
}

