/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class VersionChecker {
    private static final Logger LOG = LogManager.getLogger(VersionChecker.class);
    private List<String> allVersions;

    public String checkForUpdate(@NotNull String currentVersion, boolean checkForPreReleases) {
        LOG.debug("Current version: " + currentVersion);
        try {
            String newVersion = this.isUpdateAvailable(currentVersion, checkForPreReleases);
            if (newVersion.equals("up_to_date")) {
                return "No updates available.";
            }
            return newVersion + ";" + this.getDownloadUrl(newVersion);
        }
        catch (NumberFormatException ex) {
            LOG.error("A version could not be parsed into integers.", (Throwable)ex);
            return "No updates available.";
        }
    }

    private String isUpdateAvailable(@NotNull String currentVersion, boolean checkForPreReleases) {
        if (this.isNewBetaAvailable(currentVersion, checkForPreReleases) && checkForPreReleases) {
            return this.latestBeta();
        }
        if (this.isNewAlphaAvailable(currentVersion, checkForPreReleases) && checkForPreReleases) {
            return this.latestAlpha();
        }
        if (this.isNewSemanticVersion(currentVersion, this.latestVersion(checkForPreReleases))) {
            return this.latestVersion(checkForPreReleases);
        }
        return "up_to_date";
    }

    private boolean isNewSemanticVersion(@NotNull String currentVersion, @NotNull String newVersion) throws NumberFormatException {
        LOG.debug("Current version: " + currentVersion);
        LOG.debug("New version: " + newVersion);
        if (newVersion.equals("no_release")) {
            return false;
        }
        int newMajor = Integer.parseInt(newVersion.substring(0, 1));
        int newMinor = Integer.parseInt(newVersion.substring(2, 3));
        int newPatch = Integer.parseInt(newVersion.substring(4, 5));
        int currentMajor = Integer.parseInt(currentVersion.substring(0, 1));
        int currentMinor = Integer.parseInt(currentVersion.substring(2, 3));
        int currentPatch = Integer.parseInt(currentVersion.substring(4, 5));
        if (newMajor > currentMajor && newMinor >= currentMinor && newPatch >= currentPatch) {
            return true;
        }
        if (newMajor >= currentMajor && newMinor > currentMinor && newPatch >= currentPatch) {
            return true;
        }
        return newMajor >= currentMajor && newMinor >= currentMinor && newPatch > currentPatch;
    }

    private boolean isNewOrSameSemanticVersion(@NotNull String currentVersion, @NotNull String newVersion) throws NumberFormatException {
        if (Integer.parseInt(newVersion.substring(0, 1)) >= Integer.parseInt(currentVersion.substring(0, 1))) {
            return true;
        }
        if (Integer.parseInt(newVersion.substring(2, 3)) >= Integer.parseInt(currentVersion.substring(2, 3))) {
            return true;
        }
        return Integer.parseInt(newVersion.substring(4, 5)) >= Integer.parseInt(currentVersion.substring(4, 5));
    }

    private boolean isNewAlphaAvailable(@NotNull String currentVersion, boolean checkForPreRelease) throws NumberFormatException {
        if (!currentVersion.contains("alpha") && !checkForPreRelease) {
            return false;
        }
        if (this.latestAlpha().equals("no_alphas")) {
            return false;
        }
        String latestAlpha = this.latestAlpha();
        if (this.isNewSemanticVersion(currentVersion, latestAlpha)) {
            return true;
        }
        return Integer.parseInt(latestAlpha.substring(12)) > Integer.parseInt(currentVersion.substring(12));
    }

    private boolean isNewBetaAvailable(@NotNull String currentVersion, boolean checkForPreRelease) throws NumberFormatException {
        if (!currentVersion.contains("beta") && !checkForPreRelease) {
            return false;
        }
        if (this.latestBeta().equals("no_betas")) {
            return false;
        }
        String latestBeta = this.latestBeta();
        if (this.isNewSemanticVersion(currentVersion, latestBeta)) {
            return true;
        }
        return Integer.parseInt(latestBeta.substring(11)) > Integer.parseInt(currentVersion.substring(11));
    }

    private List<String> allBetaVersions() {
        ArrayList<String> betaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("beta") || betaVersions.contains(version)) continue;
                betaVersions.add(version);
            }
        }
        if (betaVersions.size() == 0) {
            return null;
        }
        return betaVersions;
    }

    private List<String> allAlphaVersions() {
        ArrayList<String> alphaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("alpha") || alphaVersions.contains(version)) continue;
                alphaVersions.add(version);
            }
        }
        if (alphaVersions.size() == 0) {
            return null;
        }
        return alphaVersions;
    }

    protected abstract List<String> allVersions();

    protected String latestBeta() throws NumberFormatException {
        List<String> betaVersions = this.allBetaVersions();
        String beta = "no_betas";
        if (betaVersions != null) {
            beta = betaVersions.get(0);
            for (String betaVersion : betaVersions) {
                if (!this.isNewOrSameSemanticVersion(beta, betaVersion) || Integer.parseInt(betaVersion.substring(11)) < Integer.parseInt(beta.substring(11))) continue;
                beta = betaVersion;
            }
        }
        LOG.debug("Latest beta: " + beta);
        return beta;
    }

    protected String latestAlpha() throws NumberFormatException {
        List<String> alphaVersions = this.allAlphaVersions();
        String alpha = "no_alphas";
        if (alphaVersions != null) {
            alpha = alphaVersions.get(0);
            for (String alphaVersion : alphaVersions) {
                if (!this.isNewOrSameSemanticVersion(alpha, alphaVersion) || Integer.parseInt(alphaVersion.substring(12)) <= Integer.parseInt(alpha.substring(12))) continue;
                alpha = alphaVersion;
            }
        }
        LOG.debug("Latest alpha: " + alpha);
        return alpha;
    }

    protected String getResponse(@NotNull URL requestUrl) throws IOException {
        String inputLine;
        HttpURLConnection httpURLConnection = (HttpURLConnection)requestUrl.openConnection();
        httpURLConnection.setRequestMethod("GET");
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException("Request for " + requestUrl + " responded with " + httpURLConnection.getResponseCode());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = bufferedReader.readLine()) != null) {
            response.append(inputLine);
        }
        bufferedReader.close();
        return response.toString();
    }

    public abstract void refresh() throws IOException;

    protected void setAllVersions() {
        this.allVersions = this.allVersions();
    }

    protected List<String> getAllVersions() {
        return this.allVersions;
    }

    protected abstract String latestVersion(boolean var1);

    protected abstract String getDownloadUrl(@NotNull String var1);

    protected abstract void setRepository() throws IOException;

    public abstract List<String> getAssetsDownloadUrls(@NotNull String var1);

    protected ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }
}

