/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class VersionChecker {
    private static final Logger LOG = LogManager.getLogger(VersionChecker.class);
    private List<String> allVersions;

    public String checkForUpdate(@NotNull String currentVersion, boolean checkForPreReleases) {
        LOG.debug("Current version: " + currentVersion);
        try {
            String newVersion = this.isUpdateAvailable(currentVersion, checkForPreReleases);
            if (newVersion.equals("up_to_date")) {
                return "No updates available.";
            }
            return newVersion + ";" + this.getDownloadUrl(newVersion);
        }
        catch (NumberFormatException ex) {
            LOG.error("A version could not be parsed into integers.", (Throwable)ex);
            return "No updates available.";
        }
    }

    private String isUpdateAvailable(@NotNull String currentVersion, boolean checkForPreReleases) {
        if (checkForPreReleases) {
            if (this.isNewBetaAvailable(currentVersion)) {
                return this.latestBeta();
            }
            if (this.isNewAlphaAvailable(currentVersion)) {
                return this.latestAlpha();
            }
        }
        if (this.isNewSemanticVersion(currentVersion, this.latestVersion(checkForPreReleases))) {
            return this.latestVersion(checkForPreReleases);
        }
        return "up_to_date";
    }

    private boolean isNewSemanticVersion(@NotNull String currentVersion, @NotNull String newVersion) throws NumberFormatException {
        LOG.debug("Current version: " + currentVersion);
        LOG.debug("New version: " + newVersion);
        if (newVersion.equals("no_release")) {
            return false;
        }
        String[] currentVersionSemantics = currentVersion.split("\\.");
        String[] newVersionSemantics = newVersion.split("\\.");
        int currentMajor = Integer.parseInt(currentVersionSemantics[0]);
        int currentMinor = Integer.parseInt(currentVersionSemantics[1]);
        int currentPatch = currentVersionSemantics[2].contains("-") ? Integer.parseInt(currentVersionSemantics[2].split("-")[0]) : Integer.parseInt(currentVersionSemantics[2]);
        int newMajor = Integer.parseInt(newVersionSemantics[0]);
        int newMinor = Integer.parseInt(newVersionSemantics[0]);
        int newPatch = newVersionSemantics[2].contains("-") ? Integer.parseInt(newVersionSemantics[2].split("-")[0]) : Integer.parseInt(newVersionSemantics[0]);
        return this.checkNew(newMajor, newMinor, newPatch, currentMajor, currentMinor, currentPatch);
    }

    private boolean isNewOrSameSemanticVersion(@NotNull String currentVersion, @NotNull String newVersion) throws NumberFormatException {
        LOG.debug("Current version: " + currentVersion);
        LOG.debug("New version: " + newVersion);
        if (newVersion.equals("no_release")) {
            return false;
        }
        String[] currentVersionSemantics = currentVersion.split("\\.");
        String[] newVersionSemantics = newVersion.split("\\.");
        int currentMajor = Integer.parseInt(currentVersionSemantics[0]);
        int currentMinor = Integer.parseInt(currentVersionSemantics[1]);
        int currentPatch = currentVersionSemantics[2].contains("-") ? Integer.parseInt(currentVersionSemantics[2].split("-")[0]) : Integer.parseInt(currentVersionSemantics[2]);
        int newMajor = Integer.parseInt(newVersionSemantics[0]);
        int newMinor = Integer.parseInt(newVersionSemantics[0]);
        int newPatch = newVersionSemantics[2].contains("-") ? Integer.parseInt(newVersionSemantics[2].split("-")[0]) : Integer.parseInt(newVersionSemantics[0]);
        return this.checkNewOrSame(newMajor, newMinor, newPatch, currentMajor, currentMinor, currentPatch);
    }

    private boolean checkNew(int newMajor, int newMinor, int newPatch, int currentMajor, int currentMinor, int currentPatch) {
        if (newMajor > currentMajor && newMinor == currentMinor && newPatch == currentPatch) {
            return true;
        }
        if (newMajor == currentMajor && newMinor > currentMinor && newPatch == currentPatch) {
            return true;
        }
        return newMajor == currentMajor && newMinor == currentMinor && newPatch > currentPatch;
    }

    private boolean checkNewOrSame(int newMajor, int newMinor, int newPatch, int currentMajor, int currentMinor, int currentPatch) {
        if (newMajor >= currentMajor && newMinor == currentMinor && newPatch == currentPatch) {
            return true;
        }
        if (newMajor == currentMajor && newMinor >= currentMinor && newPatch == currentPatch) {
            return true;
        }
        return newMajor == currentMajor && newMinor == currentMinor && newPatch >= currentPatch;
    }

    private boolean isNewAlphaAvailable(@NotNull String currentVersion) throws NumberFormatException {
        if (this.latestAlpha().equals("no_alphas")) {
            return false;
        }
        String latestAlpha = this.latestAlpha();
        if (this.isNewSemanticVersion(currentVersion, latestAlpha)) {
            return true;
        }
        if (currentVersion.contains("-")) {
            return this.isPreReleaseNewer(currentVersion, latestAlpha);
        }
        return false;
    }

    private boolean isNewBetaAvailable(@NotNull String currentVersion) throws NumberFormatException {
        if (this.latestBeta().equals("no_betas")) {
            return false;
        }
        String latestBeta = this.latestBeta();
        if (this.isNewSemanticVersion(currentVersion, latestBeta)) {
            return true;
        }
        if (currentVersion.contains("-")) {
            return this.isPreReleaseNewer(currentVersion, latestBeta);
        }
        return false;
    }

    private boolean isPreReleaseNewer(@NotNull String currentVersion, @NotNull String newVersion) {
        int currentVersionReleaseNumber = Integer.parseInt(currentVersion.split("-")[1].split("\\.")[1]);
        int newVersionReleaseNumber = Integer.parseInt(newVersion.split("-")[1].split("\\.")[1]);
        return newVersionReleaseNumber > currentVersionReleaseNumber;
    }

    private List<String> allBetaVersions() {
        ArrayList<String> betaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("beta") || betaVersions.contains(version)) continue;
                betaVersions.add(version);
            }
        }
        if (betaVersions.size() == 0) {
            return null;
        }
        return betaVersions;
    }

    private List<String> allAlphaVersions() {
        ArrayList<String> alphaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("alpha") || alphaVersions.contains(version)) continue;
                alphaVersions.add(version);
            }
        }
        if (alphaVersions.size() == 0) {
            return null;
        }
        return alphaVersions;
    }

    protected String latestBeta() throws NumberFormatException {
        List<String> betaVersions = this.allBetaVersions();
        String beta = "no_betas";
        if (betaVersions != null) {
            beta = betaVersions.get(0);
            for (String betaVersion : betaVersions) {
                if (!this.isNewOrSameSemanticVersion(beta, betaVersion) || !this.isPreReleaseNewer(beta, betaVersion)) continue;
                beta = betaVersion;
            }
        }
        LOG.debug("Latest beta: " + beta);
        return beta;
    }

    protected String latestAlpha() throws NumberFormatException {
        List<String> alphaVersions = this.allAlphaVersions();
        String alpha = "no_alphas";
        if (alphaVersions != null) {
            alpha = alphaVersions.get(0);
            for (String alphaVersion : alphaVersions) {
                if (!this.isNewOrSameSemanticVersion(alpha, alphaVersion) || !this.isPreReleaseNewer(alpha, alphaVersion)) continue;
                alpha = alphaVersion;
            }
        }
        LOG.debug("Latest alpha: " + alpha);
        return alpha;
    }

    protected String getResponse(@NotNull URL requestUrl) throws IOException {
        String inputLine;
        HttpURLConnection httpURLConnection = (HttpURLConnection)requestUrl.openConnection();
        httpURLConnection.setRequestMethod("GET");
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException("Request for " + requestUrl + " responded with " + httpURLConnection.getResponseCode());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = bufferedReader.readLine()) != null) {
            response.append(inputLine);
        }
        bufferedReader.close();
        return response.toString();
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    protected abstract List<String> allVersions();

    public abstract VersionChecker refresh() throws IOException;

    protected void setAllVersions() {
        this.allVersions = this.allVersions();
    }

    protected List<String> getAllVersions() {
        return this.allVersions;
    }

    protected abstract String latestVersion(boolean var1);

    protected abstract String getDownloadUrl(@NotNull String var1);

    protected abstract void setRepository() throws IOException;

    public abstract List<String> getAssetsDownloadUrls(@NotNull String var1);
}

