/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker.gitlab;

import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.versionchecker.VersionChecker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitLabChecker
extends VersionChecker {
    private static final Logger LOG = LogManager.getLogger(GitLabChecker.class);
    private final URL GITLAB_API;
    private JsonNode repository;

    public GitLabChecker(@NotNull String repositoryUrl) throws MalformedURLException {
        this.GITLAB_API = new URL(repositoryUrl);
    }

    @Override
    public GitLabChecker refresh() throws IOException {
        this.setRepository();
        this.setAllVersions();
        return this;
    }

    @Override
    public List<String> allVersions() {
        ArrayList<String> versions = new ArrayList<String>(1000);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (versions.contains(version.get("tag_name").asText())) continue;
                versions.add(version.get("tag_name").asText());
            }
        }
        LOG.debug("All versions: " + versions);
        if (versions == null || versions.size() == 0) {
            return null;
        }
        return versions;
    }

    @Override
    public String latestVersion(boolean checkForPreRelease) {
        for (String version : this.getAllVersions()) {
            LOG.debug("version: " + version);
            if (version.contains("alpha") || version.contains("beta")) continue;
            return version;
        }
        if (checkForPreRelease) {
            if (!this.latestBeta().equals("no_betas")) {
                return this.latestBeta();
            }
            if (!this.latestAlpha().equals("no_alphas")) {
                return this.latestAlpha();
            }
        }
        return "no_release";
    }

    @Override
    public String getDownloadUrl(@NotNull String version) {
        if (this.repository != null) {
            for (JsonNode tag : this.repository) {
                if (!tag.get("tag_name").asText().equals(version)) continue;
                return tag.get("_links").get("self").asText();
            }
        }
        return "No URL found.";
    }

    @Override
    protected void setRepository() throws IOException {
        this.repository = this.getObjectMapper().readTree(this.getResponse(this.GITLAB_API));
    }

    @Override
    public List<String> getAssetsDownloadUrls(@NotNull String requestedVersion) {
        ArrayList<String> assetUrls = new ArrayList<String>(20);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (!version.get("tag_name").asText().equals(requestedVersion)) continue;
                for (JsonNode asset : version.get("assets").get("links")) {
                    if (assetUrls.contains(asset.get("url").asText())) continue;
                    assetUrls.add(asset.get("url").asText());
                }
            }
        }
        return assetUrls;
    }
}

