/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker.github;

import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.versionchecker.Comparison;
import de.griefed.versionchecker.VersionChecker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitHubChecker
extends VersionChecker {
    private static final Logger LOG = LogManager.getLogger(GitHubChecker.class);
    private final URL GITHUB_API;
    private final URL GITHUB_API_LATEST;
    private JsonNode repository;
    private JsonNode latest;

    public GitHubChecker(@NotNull String gitHubUserRepository) throws MalformedURLException {
        this.GITHUB_API = new URL("https://api.github.com/repos/" + gitHubUserRepository + "/releases");
        this.GITHUB_API_LATEST = new URL("https://api.github.com/repos/" + gitHubUserRepository + "/releases/latest");
    }

    @Override
    public GitHubChecker refresh() throws IOException {
        this.setRepository();
        this.setLatest();
        this.setAllVersions();
        return this;
    }

    @Override
    public List<String> allVersions() {
        ArrayList<String> versions = new ArrayList<String>(1000);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (versions.contains(version.get("tag_name").asText())) continue;
                versions.add(version.get("tag_name").asText());
            }
        }
        LOG.debug("All versions: " + versions);
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    @Override
    public String latestVersion(boolean checkForPreRelease) {
        if (this.latest != null) {
            String version = this.latest.get("tag_name").asText();
            if (checkForPreRelease) {
                String alpha = this.latestAlpha();
                String beta = this.latestBeta();
                if (!beta.equals("no_betas") && this.compareSemantics(version, beta, Comparison.NEW)) {
                    version = beta;
                }
                if (!alpha.equals("no_alphas") && this.compareSemantics(version, alpha, Comparison.NEW)) {
                    version = alpha;
                }
            }
            LOG.debug("Latest version:" + this.latest);
            return version;
        }
        return "no_release";
    }

    @Override
    public String getDownloadUrl(@NotNull String version) {
        if (this.repository != null) {
            for (JsonNode tag : this.repository) {
                if (!tag.get("tag_name").asText().equals(version)) continue;
                return tag.get("html_url").asText();
            }
        }
        return "No URL found.";
    }

    @Override
    protected void setRepository() throws IOException {
        this.repository = this.getObjectMapper().readTree(this.getResponse(this.GITHUB_API));
    }

    private void setLatest() throws IOException {
        this.latest = this.getObjectMapper().readTree(this.getResponse(this.GITHUB_API_LATEST));
    }

    @Override
    public List<String> getAssetsDownloadUrls(@NotNull String requestedVersion) {
        ArrayList<String> assetUrls = new ArrayList<String>(20);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (!version.get("tag_name").asText().equals(requestedVersion)) continue;
                for (JsonNode asset : version.get("assets")) {
                    if (assetUrls.contains(asset.get("browser_download_url").asText())) continue;
                    assetUrls.add(asset.get("browser_download_url").asText());
                }
            }
        }
        return assetUrls;
    }
}

