/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.versionchecker.ArchiveType;
import de.griefed.versionchecker.Comparison;
import de.griefed.versionchecker.ReleaseAsset;
import de.griefed.versionchecker.Source;
import de.griefed.versionchecker.Update;
import de.griefed.versionchecker.VersionChecker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitHubChecker
extends VersionChecker {
    private static final Logger LOG = LogManager.getLogger(GitHubChecker.class);
    private final URL GITHUB_API;
    private final URL GITHUB_API_LATEST;
    private JsonNode repository;
    private JsonNode latest;

    public GitHubChecker(@NotNull String gitHubUserRepository) throws MalformedURLException {
        this.GITHUB_API = new URL("https://api.github.com/repos/" + gitHubUserRepository + "/releases");
        this.GITHUB_API_LATEST = new URL("https://api.github.com/repos/" + gitHubUserRepository + "/releases/latest");
    }

    public GitHubChecker(@NotNull String user, @NotNull String repository) throws MalformedURLException {
        this.GITHUB_API = new URL("https://api.github.com/repos/" + user + "/" + repository + "/releases");
        this.GITHUB_API_LATEST = new URL("https://api.github.com/repos/" + user + "/" + repository + "/releases/latest");
    }

    @Override
    public GitHubChecker refresh() throws IOException {
        this.setRepository();
        this.setLatest();
        this.setAllVersions();
        return this;
    }

    @Override
    public Optional<Update> check(@NotNull String currentVersion, boolean checkForPreReleases) {
        LOG.debug("Current version: " + currentVersion);
        try {
            String newVersion = this.isUpdateAvailable(currentVersion, checkForPreReleases);
            if (!newVersion.equals("up_to_date")) {
                String description = "N/A";
                LocalDate releaseDate = null;
                ArrayList<ReleaseAsset> assets = new ArrayList<ReleaseAsset>();
                ArrayList<Source> sources = new ArrayList<Source>();
                for (JsonNode release : this.repository) {
                    if (!release.get("tag_name").asText().equals(newVersion)) continue;
                    description = release.get("body").asText();
                    releaseDate = LocalDate.parse(release.get("published_at").asText().substring(0, release.get("published_at").asText().lastIndexOf("T")));
                    for (JsonNode asset : release.get("assets")) {
                        assets.add(new ReleaseAsset(asset.get("name").asText(), new URL(asset.get("browser_download_url").asText())));
                    }
                    sources.add(new Source(ArchiveType.TAR_GZ, new URL(release.get("tarball_url").asText())));
                    sources.add(new Source(ArchiveType.ZIP, new URL(release.get("zipball_url").asText())));
                    break;
                }
                return Optional.of(new Update(newVersion, description, new URL(this.getDownloadUrl(newVersion)), releaseDate, assets, sources));
            }
        }
        catch (NumberFormatException ex) {
            LOG.error("A version could not be parsed into integers.", (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            LOG.error("URL could not be created.", (Throwable)ex);
        }
        return Optional.empty();
    }

    @Override
    public List<String> allVersions() {
        ArrayList<String> versions = new ArrayList<String>(1000);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (versions.contains(version.get("tag_name").asText())) continue;
                versions.add(version.get("tag_name").asText());
            }
        }
        LOG.debug("All versions: " + versions);
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    @Override
    public String latestVersion(boolean checkForPreRelease) {
        if (this.latest != null) {
            String version = this.latest.get("tag_name").asText();
            if (checkForPreRelease) {
                String alpha = this.latestAlpha();
                String beta = this.latestBeta();
                if (!beta.equals("no_betas") && this.compareSemantics(version, beta, Comparison.NEW)) {
                    version = beta;
                }
                if (!alpha.equals("no_alphas") && this.compareSemantics(version, alpha, Comparison.NEW)) {
                    version = alpha;
                }
            }
            LOG.debug("Latest version:" + this.latest);
            return version;
        }
        return "no_release";
    }

    @Override
    public String getDownloadUrl(@NotNull String version) {
        if (this.repository != null) {
            for (JsonNode tag : this.repository) {
                if (!tag.get("tag_name").asText().equals(version)) continue;
                return tag.get("html_url").asText();
            }
        }
        return "No URL found.";
    }

    @Override
    protected void setRepository() throws IOException {
        this.repository = this.getObjectMapper().readTree(this.getResponse(this.GITHUB_API));
    }

    private void setLatest() throws IOException {
        this.latest = this.getObjectMapper().readTree(this.getResponse(this.GITHUB_API_LATEST));
    }

    @Override
    @Deprecated
    public List<String> getAssetsDownloadUrls(@NotNull String requestedVersion) {
        ArrayList<String> assetUrls = new ArrayList<String>(20);
        if (this.repository != null) {
            for (JsonNode version : this.repository) {
                if (!version.get("tag_name").asText().equals(requestedVersion)) continue;
                for (JsonNode asset : version.get("assets")) {
                    if (assetUrls.contains(asset.get("browser_download_url").asText())) continue;
                    assetUrls.add(asset.get("browser_download_url").asText());
                }
            }
        }
        return assetUrls;
    }
}

