/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;

public class DataSetBuilder {
    protected String name;
    protected double[] xValues;
    protected double[] yValues;
    protected double[] yErrorsPos;
    protected double[] yErrorsNeg;
    protected int initialCapacity = -1;

    public DataSetBuilder() {
        this("default data set");
    }

    public DataSetBuilder(String dataSetName) {
        this.setName(dataSetName);
    }

    public final DataSetBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public final DataSetBuilder setXValuesNoCopy(double[] xValues) {
        this.xValues = xValues;
        return this;
    }

    public final DataSetBuilder setXValues(double[] xValues) {
        int size = this.initialCapacity < 0 ? xValues.length : Math.min(this.initialCapacity, xValues.length);
        this.xValues = new double[size];
        System.arraycopy(xValues, 0, this.xValues, 0, size);
        return this;
    }

    public final DataSetBuilder setYValuesNoCopy(double[] yValues) {
        this.yValues = yValues;
        return this;
    }

    public final DataSetBuilder setYValues(double[] yValues) {
        int size = this.initialCapacity < 0 ? yValues.length : Math.min(this.initialCapacity, yValues.length);
        this.yValues = new double[size];
        System.arraycopy(yValues, 0, this.yValues, 0, size);
        return this;
    }

    public final DataSetBuilder setYPosErrorNoCopy(double[] yErrorValuesPos) {
        this.yErrorsPos = yErrorValuesPos;
        return this;
    }

    public final DataSetBuilder setYPosError(double[] yErrorValuesPos) {
        int size = this.initialCapacity < 0 ? yErrorValuesPos.length : Math.min(this.initialCapacity, yErrorValuesPos.length);
        this.yErrorsPos = new double[size];
        System.arraycopy(yErrorValuesPos, 0, this.yErrorsPos, 0, size);
        return this;
    }

    public DataSetBuilder setYNegErrorNoCopy(double[] yErrorValuesNeg) {
        this.yErrorsNeg = yErrorValuesNeg;
        return this;
    }

    public DataSetBuilder setYNegError(double[] yErrorValuesNeg) {
        int size = this.initialCapacity < 0 ? yErrorValuesNeg.length : Math.min(this.initialCapacity, yErrorValuesNeg.length);
        this.yErrorsNeg = new double[size];
        System.arraycopy(yErrorValuesNeg, 0, this.yErrorsNeg, 0, size);
        return this;
    }

    public DataSet build() {
        int size;
        Object dsName;
        Object object = dsName = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        if (this.xValues == null && this.yValues == null) {
            return new DefaultDataSet((String)dsName, Math.max(this.initialCapacity, 0));
        }
        double[] dsX = this.xValues == null ? new double[this.yValues.length] : this.xValues;
        double[] dsY = this.yValues == null ? new double[this.xValues.length] : this.yValues;
        int minArrays = Math.min(dsX.length, dsY.length);
        int n = size = this.initialCapacity < 0 ? minArrays : Math.min(minArrays, this.initialCapacity);
        if (this.yErrorsNeg == null && this.yErrorsPos == null) {
            return new DefaultDataSet((String)dsName, dsX, dsY, size, false);
        }
        double[] dsYep = this.yErrorsPos == null ? this.yErrorsNeg : this.yErrorsPos;
        double[] dsYen = this.yErrorsNeg == null ? this.yErrorsPos : this.yErrorsNeg;
        AssertUtils.equalDoubleArrays(this.xValues, this.yErrorsPos, size);
        AssertUtils.equalDoubleArrays(this.xValues, this.yErrorsNeg, size);
        return new DefaultErrorDataSet((String)dsName, dsX, dsY, dsYen, dsYep, size, false);
    }
}

