/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset;

import de.gsi.dataset.event.EventSource;

public interface DataSet
extends EventSource {
    public String getName();

    public DataSet lock();

    public DataSet unlock();

    public DataSet setAutoNotifaction(boolean var1);

    public boolean isAutoNotification();

    public int getDataCount();

    public int getDataCount(double var1, double var3);

    public double getX(int var1);

    public double getY(int var1);

    default public double[] getXValues() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getX(i);
        }
        return retValues;
    }

    default public double[] getYValues() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getY(i);
        }
        return retValues;
    }

    default public double getValue(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double x2 = this.getX(index2);
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        if (x1 == x2) {
            return y1;
        }
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public Double getUndefValue();

    public int getXIndex(double var1);

    public int getYIndex(double var1);

    public double getXMin();

    public double getXMax();

    public double getYMin();

    public double getYMax();

    public String getDataLabel(int var1);

    public String getStyle();

    public String getStyle(int var1);

    public DataSet setStyle(String var1);
}

