/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.ArrayDeque;
import java.util.Arrays;

public class AveragingDataSet
extends AbstractDataSet<AveragingDataSet> {
    private int averageSize = 1;
    private int fuzzyCount = 0;
    private InternalDataSet dataset;
    private final ArrayDeque<DataSet> deque = new ArrayDeque();

    public AveragingDataSet(String name) {
        super(name);
    }

    public AveragingDataSet(String name, int fuzzyCount) {
        super(name);
        this.fuzzyCount = fuzzyCount;
    }

    public int getFuzzyCount() {
        return this.fuzzyCount;
    }

    public void setFuzzyCount(int fuzzyCount) {
        this.fuzzyCount = fuzzyCount;
    }

    public int getAverageSize() {
        return this.averageSize;
    }

    public void setAverageSize(int avgCount) {
        if (avgCount < 1) {
            return;
        }
        if (this.averageSize != avgCount) {
            this.deque.clear();
            this.dataset = null;
        }
        this.averageSize = avgCount;
    }

    public int getAverageCount() {
        if (this.averageSize == 1) {
            return this.dataset == null ? 0 : 1;
        }
        return this.deque.size();
    }

    public void clear() {
        this.deque.clear();
        this.dataset = null;
    }

    public void add(DataSet ds) {
        if (this.averageSize == 1) {
            this.dataset = new InternalDataSet(ds);
        } else if (this.dataset == null || this.deque.isEmpty()) {
            this.dataset = new InternalDataSet(ds);
            this.deque.clear();
            this.deque.add(new InternalDataSet(ds));
        } else if (this.deque.size() < this.averageSize) {
            this.dataset.opScale(this.deque.size());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        } else {
            this.dataset.opScale(this.deque.size());
            this.dataset.opSub(this.deque.pop());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        }
        this.dataset.computeLimits();
        this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public int getDataCount() {
        if (this.dataset == null) {
            return 0;
        }
        return this.dataset.getDataCount();
    }

    @Override
    public int getDataCount(double xmin, double xmax) {
        if (this.dataset == null) {
            return 0;
        }
        return this.dataset.getDataCount(xmin, xmax);
    }

    @Override
    public double[] getYValues() {
        if (this.dataset == null) {
            return new double[0];
        }
        return this.dataset.getYValues();
    }

    @Override
    public double getX(int i) {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getX(i);
    }

    @Override
    public double getY(int i) {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getY(i);
    }

    @Override
    public int getXIndex(double x) {
        if (this.dataset == null) {
            return 0;
        }
        return this.dataset.getXIndex(x);
    }

    @Override
    public double getXMin() {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getXMin();
    }

    @Override
    public double getXMax() {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getXMax();
    }

    @Override
    public double getYMin() {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getYMin();
    }

    @Override
    public double getYMax() {
        if (this.dataset == null) {
            return 0.0;
        }
        return this.dataset.getYMax();
    }

    @Override
    public String getStyle(int index) {
        if (this.dataset == null) {
            return "";
        }
        return this.dataset.getStyle(index);
    }

    private class InternalDataSet
    extends DoubleDataSet {
        public InternalDataSet(DataSet ds) {
            super(ds.getName(), ds.getXValues(), ds.getYValues(), ds.getDataCount(), true);
        }

        public boolean isCompatible(DataSet d) {
            return Math.abs(this.getDataCount() - d.getDataCount()) <= AveragingDataSet.this.fuzzyCount;
        }

        public void opAdd(DataSet d) {
            if (!this.isCompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            if (this.yValues.length > d.getDataCount()) {
                this.yValues = Arrays.copyOf(this.yValues, d.getDataCount());
            }
            for (int i = 0; i < this.yValues.length; ++i) {
                int n = i;
                this.yValues[n] = this.yValues[n] + d.getY(i);
            }
        }

        public void opSub(DataSet d) {
            if (!this.isCompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            if (this.yValues.length > d.getDataCount()) {
                this.yValues = Arrays.copyOf(this.yValues, d.getDataCount());
            }
            for (int i = 0; i < this.yValues.length; ++i) {
                int n = i;
                this.yValues[n] = this.yValues[n] - d.getY(i);
            }
        }

        public void opScale(double f) {
            int i = 0;
            while (i < this.yValues.length) {
                int n = i++;
                this.yValues[n] = this.yValues[n] * f;
            }
        }
    }
}

