/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.Map;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet {
    protected double[] xValues;
    protected double[] yValues;
    protected int dataMaxIndex;

    public DoubleDataSet(String name) {
        this(name, 0);
    }

    public DoubleDataSet(DataSet another) {
        this("");
        another.lock();
        this.setName(another.getName());
        this.set(another);
        another.unlock();
    }

    public DoubleDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.dataMaxIndex = 0;
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues, int initalSize, boolean deepCopy) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, initalSize));
        AssertUtils.equalDoubleArrays(xValues, yValues, initalSize);
        if (deepCopy) {
            this.xValues = new double[this.dataMaxIndex];
            this.yValues = new double[this.dataMaxIndex];
            System.arraycopy(xValues, 0, this.xValues, 0, Math.min(xValues.length, initalSize));
            System.arraycopy(yValues, 0, this.yValues, 0, Math.min(yValues.length, initalSize));
        } else {
            this.xValues = xValues;
            this.yValues = yValues;
        }
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public double[] getXValues() {
        return this.xValues;
    }

    @Override
    public double[] getYValues() {
        return this.yValues;
    }

    @Override
    public int getDataCount() {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public DoubleDataSet clearData() {
        this.lock();
        this.dataMaxIndex = 0;
        Arrays.fill(this.xValues, 0.0);
        Arrays.fill(this.yValues, 0.0);
        this.dataLabels.isEmpty();
        this.dataStyles.isEmpty();
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double getX(int index) {
        return this.xValues[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleDataSet set(int index, double x, double y) {
        this.lock();
        try {
            this.xValues[index] = x;
            this.yValues[index] = y;
            this.dataMaxIndex = Math.max(index, this.dataMaxIndex);
            this.xRange.add(x);
            this.yRange.add(y);
        }
        finally {
            this.unlock();
        }
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleDataSet add(double x, double y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public DoubleDataSet add(double x, double y, String label) {
        return this.add(this.getDataCount(), x, y, label);
    }

    @Override
    public DoubleDataSet add(int index, double x, double y) {
        return this.add(index, x, y, null);
    }

    public DoubleDataSet add(int index, double x, double y, String label) {
        this.lock();
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        int minArraySize = Math.min(this.xValues.length - 1, this.yValues.length - 1);
        if (this.dataMaxIndex > minArraySize) {
            double[] xValuesNew = new double[this.dataMaxIndex + 1];
            double[] yValuesNew = new double[this.dataMaxIndex + 1];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, indexAt);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, indexAt);
            System.arraycopy(this.xValues, indexAt, xValuesNew, indexAt + 1, this.xValues.length - indexAt);
            System.arraycopy(this.yValues, indexAt, yValuesNew, indexAt + 1, this.yValues.length - indexAt);
            for (int i = this.xValues.length; i >= indexAt; --i) {
                String oldStyleData;
                String oldLabelData = (String)this.dataLabels.get(i);
                if (oldLabelData != null) {
                    this.dataLabels.put(i + 1, oldLabelData);
                    this.dataLabels.remove(i);
                }
                if ((oldStyleData = (String)this.dataStyles.get(i)) == null) continue;
                this.dataStyles.put(i + 1, oldStyleData);
                this.dataStyles.remove(i);
            }
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
        }
        this.xValues[indexAt] = x;
        this.yValues[indexAt] = y;
        if (label != null && !label.isEmpty()) {
            this.addDataLabel(indexAt, label);
        }
        ++this.dataMaxIndex;
        this.xRange.add(x);
        this.yRange.add(y);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        int diffLength = toIndex - fromIndex;
        int newLength = this.xValues.length - diffLength;
        double[] xValuesNew = new double[newLength];
        double[] yValuesNew = new double[newLength];
        System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
        System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
        System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
        this.xValues = xValuesNew;
        this.yValues = yValuesNew;
        for (int i = 0; i < diffLength; ++i) {
            String oldStyleData;
            String oldLabelData = (String)this.dataLabels.get(toIndex + i);
            if (oldLabelData != null) {
                this.dataLabels.put(fromIndex + i, oldLabelData);
                this.dataLabels.remove(toIndex + i);
            }
            if ((oldStyleData = (String)this.dataStyles.get(toIndex + i)) == null) continue;
            this.dataStyles.put(fromIndex + i, oldStyleData);
            this.dataStyles.remove(toIndex + i);
        }
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleDataSet add(double[] xValuesNew, double[] yValuesNew) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        int newLength = this.getDataCount() + xValuesNew.length;
        if (newLength > this.xValues.length) {
            double[] xValuesNewAlloc = new double[newLength];
            double[] yValuesNewAlloc = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNewAlloc, 0, this.getDataCount());
            System.arraycopy(this.yValues, 0, yValuesNewAlloc, 0, this.getDataCount());
            this.xValues = xValuesNewAlloc;
            this.yValues = yValuesNewAlloc;
        }
        System.arraycopy(xValuesNew, 0, this.xValues, this.getDataCount(), xValuesNew.length);
        System.arraycopy(yValuesNew, 0, this.yValues, this.getDataCount(), xValuesNew.length);
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValuesNew.length);
        this.computeLimits();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        if (!copy) {
            this.xValues = xValues;
            this.yValues = yValues;
            this.dataMaxIndex = xValues.length;
            this.computeLimits();
            return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
        }
        if (xValues.length == this.xValues.length) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
            System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
        } else {
            this.xValues = Arrays.copyOf(xValues, xValues.length);
            this.yValues = Arrays.copyOf(yValues, xValues.length);
        }
        this.dataMaxIndex = xValues.length;
        this.computeLimits();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public DoubleDataSet set(DataSet other) {
        int index;
        this.lock();
        other.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.dataLabels.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String label = other.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            this.addDataLabel(index, label);
        }
        this.dataStyles.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String style = other.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            this.addDataStyle(index, style);
        }
        this.setStyle(other.getStyle());
        this.set(other.getXValues(), other.getYValues(), true);
        this.setAutoNotifaction(oldAuto);
        other.unlock();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }
}

