/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.Map;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
EditableDataSet {
    protected double[] xValues;
    protected double[] yValues;
    protected double[] yErrorsPos;
    protected double[] yErrorsNeg;
    protected int dataMaxIndex;

    public DoubleErrorDataSet(String name) {
        this(name, 0);
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new double[initalSize];
        this.yValues = new double[initalSize];
        this.yErrorsPos = new double[initalSize];
        this.yErrorsNeg = new double[initalSize];
        this.setErrorType(DataSetError.ErrorType.Y_ASYMMETRIC);
        this.dataMaxIndex = 0;
    }

    public DoubleErrorDataSet(DataSet another) {
        this("");
        another.lock();
        this.setName(another.getName());
        this.set(another);
        another.unlock();
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int nData, boolean deepCopy) {
        this(name, Math.min(xValues.length, Math.min(yValues.length, nData)));
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        int errorMin = Math.min(Math.min(yErrorsPos.length, yErrorsNeg.length), nData);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, this.dataMaxIndex);
        if (this.dataMaxIndex != 0 && deepCopy) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.dataMaxIndex);
            System.arraycopy(yValues, 0, this.yValues, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.dataMaxIndex);
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.dataMaxIndex);
        } else {
            this.xValues = xValues;
            this.yValues = yValues;
            this.yErrorsPos = yErrorsPos;
            this.yErrorsNeg = yErrorsNeg;
        }
        this.computeLimits();
    }

    public Map<Integer, String> getDataLabelMap() {
        return this.dataLabels;
    }

    public Map<Integer, String> getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public double[] getXValues() {
        return this.xValues;
    }

    @Override
    public double[] getYValues() {
        return this.yValues;
    }

    @Override
    public double[] getYErrorsPositive() {
        return this.yErrorsPos;
    }

    @Override
    public double[] getYErrorsNegative() {
        return this.yErrorsNeg;
    }

    @Override
    public int getDataCount() {
        return Math.min(this.dataMaxIndex, this.xValues.length);
    }

    public DoubleErrorDataSet clearData() {
        this.lock();
        this.dataMaxIndex = 0;
        Arrays.fill(this.xValues, 0.0);
        Arrays.fill(this.yValues, 0.0);
        Arrays.fill(this.yErrorsPos, 0.0);
        Arrays.fill(this.yErrorsNeg, 0.0);
        this.dataLabels.isEmpty();
        this.dataStyles.isEmpty();
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double getX(int index) {
        return this.xValues[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues[index];
    }

    @Override
    public double getXErrorNegative(int index) {
        return 0.0;
    }

    @Override
    public double getXErrorPositive(int index) {
        return 0.0;
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.yErrorsNeg[index];
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.yErrorsPos[index];
    }

    @Override
    public DoubleErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        try {
            if (index < this.dataMaxIndex) {
                this.xValues[index] = x;
                this.yValues[index] = y;
                this.yErrorsPos[index] = yErrorPos;
                this.yErrorsNeg[index] = yErrorNeg;
            } else {
                this.add(x, y, yErrorNeg, yErrorPos);
            }
            this.xRange.add(x);
            this.yRange.add(y - yErrorNeg);
            this.yRange.add(y + yErrorPos);
        }
        finally {
            this.setAutoNotifaction(oldAuto);
            this.unlock();
        }
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock();
        if (this.dataMaxIndex > this.xValues.length - 1) {
            double[] xValuesNew = new double[this.xValues.length + 1];
            double[] yValuesNew = new double[this.yValues.length + 1];
            double[] yErrorsNegNew = new double[this.yValues.length + 1];
            double[] yErrorsPosNew = new double[this.yValues.length + 1];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, this.xValues.length);
            System.arraycopy(this.yValues, 0, yValuesNew, 0, this.yValues.length);
            System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, this.yValues.length);
            System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, this.yValues.length);
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            this.yErrorsPos = yErrorsPosNew;
            this.yErrorsNeg = yErrorsNegNew;
        }
        this.xValues[this.dataMaxIndex] = x;
        this.yValues[this.dataMaxIndex] = y;
        this.yErrorsPos[this.dataMaxIndex] = yErrorPos;
        this.yErrorsNeg[this.dataMaxIndex] = yErrorNeg;
        ++this.dataMaxIndex;
        this.xRange.add(x);
        this.yRange.add(y - yErrorNeg);
        this.yRange.add(y + yErrorPos);
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        int diffLength = toIndex - fromIndex;
        int newLength = this.xValues.length - diffLength;
        double[] xValuesNew = new double[newLength];
        double[] yValuesNew = new double[newLength];
        double[] yErrorsNegNew = new double[newLength];
        double[] yErrorsPosNew = new double[newLength];
        System.arraycopy(this.xValues, 0, xValuesNew, 0, fromIndex);
        System.arraycopy(this.yValues, 0, yValuesNew, 0, fromIndex);
        System.arraycopy(this.yErrorsNeg, 0, yErrorsNegNew, 0, fromIndex);
        System.arraycopy(this.yErrorsPos, 0, yErrorsPosNew, 0, fromIndex);
        System.arraycopy(this.xValues, toIndex, xValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yValues, toIndex, yValuesNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yErrorsNeg, toIndex, yErrorsNegNew, fromIndex, newLength - fromIndex);
        System.arraycopy(this.yErrorsPos, toIndex, yErrorsPosNew, fromIndex, newLength - fromIndex);
        this.xValues = xValuesNew;
        this.yValues = yValuesNew;
        this.yErrorsPos = yErrorsPosNew;
        this.yErrorsNeg = yErrorsNegNew;
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex - diffLength);
        this.xRange.empty();
        this.yRange.empty();
        ((DoubleErrorDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
        return this;
    }

    @Override
    public EditableDataSet add(int index, double x, double y) {
        return null;
    }

    public DoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos);
        int newLength = this.getDataCount() + xValues.length;
        if (newLength > this.xValues.length) {
            double[] xValuesNew = new double[newLength];
            double[] yValuesNew = new double[newLength];
            double[] yErrorsNegNew = new double[newLength];
            double[] yErrorsPosNew = new double[newLength];
            System.arraycopy(this.xValues, 0, xValuesNew, 0, this.getDataCount());
            System.arraycopy(this.yValues, 0, yValuesNew, 0, this.getDataCount());
            System.arraycopy(yErrorsNeg, 0, yErrorsNegNew, 0, this.getDataCount());
            System.arraycopy(yErrorsPos, 0, yErrorsPosNew, 0, this.getDataCount());
            this.xValues = xValuesNew;
            this.yValues = yValuesNew;
            this.yErrorsNeg = yErrorsNegNew;
            this.yErrorsPos = yErrorsPosNew;
        }
        System.arraycopy(xValues, 0, this.xValues, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yValues, 0, this.yValues, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, this.getDataCount(), newLength - this.getDataCount());
        System.arraycopy(yErrorsPos, 0, this.yErrorsPos, this.getDataCount(), newLength - this.getDataCount());
        this.dataMaxIndex = Math.max(0, this.dataMaxIndex + xValues.length);
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        this.dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, this.dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, this.dataMaxIndex);
        if (!copy) {
            this.xValues = xValues;
            this.yValues = yValues;
            this.yErrorsNeg = yErrorsNeg;
            this.yErrorsPos = yErrorsPos;
            this.computeLimits();
            this.unlock();
            this.fireInvalidated(new UpdatedDataEvent(this));
            return this;
        }
        if (xValues.length == this.xValues.length) {
            System.arraycopy(xValues, 0, this.xValues, 0, this.getDataCount());
            System.arraycopy(yValues, 0, this.yValues, 0, this.getDataCount());
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg, 0, this.getDataCount());
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos, 0, this.getDataCount());
        } else {
            this.xValues = Arrays.copyOf(xValues, xValues.length);
            this.yValues = Arrays.copyOf(yValues, xValues.length);
            this.yErrorsNeg = Arrays.copyOf(yErrorsNeg, xValues.length);
            this.yErrorsPos = Arrays.copyOf(yErrorsPos, xValues.length);
        }
        this.computeLimits();
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(DataSet other) {
        int index;
        this.lock();
        other.lock();
        this.dataLabels.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String label = other.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            this.addDataLabel(index, label);
        }
        this.dataStyles.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String style = other.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            this.addDataStyle(index, style);
        }
        this.setStyle(other.getStyle());
        if (other instanceof DataSetError) {
            this.set(other.getXValues(), other.getYValues(), ((DataSetError)other).getYErrorsNegative(), ((DataSetError)other).getYErrorsPositive(), true);
        } else {
            int count = other.getDataCount();
            this.set(other.getXValues(), other.getYValues(), new double[count], new double[count], true);
        }
        other.unlock();
        return (DoubleErrorDataSet)this.unlock();
    }
}

