/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.Histogram2D;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram2
extends AbstractHistogram
implements Histogram2D {
    protected final Histogram xProjection;
    protected final Histogram yProjection;

    public Histogram2(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY) {
        super(name, nBinsX, minX, maxX, nBinsY, minY, maxY);
        this.xProjection = new Histogram(name + "-Proj-X", nBinsX, minX, maxX, true);
        this.yProjection = new Histogram(name + "-Proj-Y", nBinsY, minY, maxY, false);
    }

    public Histogram1D getProjectionX() {
        return this.xProjection;
    }

    public Histogram1D getProjectionY() {
        return this.yProjection;
    }

    @Override
    public void reset() {
        this.xProjection.reset();
        this.yProjection.reset();
        super.reset();
    }

    @Override
    public double getZ(int xIndex, int yIndex) {
        int bin = (yIndex + 1) * this.getNBinsX() + xIndex + 1;
        return super.getBinContent(bin);
    }

    @Override
    public int getXDataCount() {
        return this.getNBinsX() - 2;
    }

    @Override
    public int getYDataCount() {
        return this.getNBinsY() - 2;
    }

    @Override
    public double getX(int i) {
        return this.getBinCenterX(i + 1);
    }

    @Override
    public double getY(int i) {
        return this.getBinCenterY(i + 1);
    }

    @Override
    public int fill(double x, double y) {
        this.xProjection.fill(x);
        this.yProjection.fill(y);
        int bin = super.findBin(x, y);
        super.addBinContent(bin);
        return bin;
    }

    @Override
    public int fill(double x, double y, double w) {
        this.xProjection.fill(x, w);
        this.yProjection.fill(y, w);
        int bin = super.findBin(x, y);
        super.addBinContent(bin, w);
        return bin;
    }

    @Override
    public int findFirstBinAbove(double x, double y) {
        return this.findBin(x, y);
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    protected double getSumX(int bin) {
        double sum = 0.0;
        for (int i = 0; i < this.getNBinsX(); ++i) {
            sum += this.getZ(i - 1, bin - 1);
        }
        return sum;
    }

    protected double getSumY(int bin) {
        double sum = 0.0;
        for (int i = 0; i < this.getNBinsY(); ++i) {
            sum += this.getZ(bin - 1, i - 1);
        }
        return sum;
    }

    @Override
    public List<String> getWarningList() {
        LinkedList<String> retVal = new LinkedList<String>();
        if (this.getSumX(0) > 0.0) {
            retVal.add("under-range-x");
        }
        if (this.getSumX(this.getNBinsX() - 1) > 0.0) {
            retVal.add("over-range-x");
        }
        if (this.getSumY(0) > 0.0) {
            retVal.add("under-range-y");
        }
        if (this.getSumY(this.getNBinsY() - 1) > 0.0) {
            retVal.add("over-range-y");
        }
        return retVal;
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }
}

