/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.testdata.spi.AbstractTestFunction;

public class SineFunction
extends AbstractTestFunction<SineFunction>
implements DataSetError {
    private final boolean useSystemTimeOffset;

    public SineFunction(String name, int count) {
        super(name, count);
        this.useSystemTimeOffset = false;
    }

    public SineFunction(String name, int count, boolean useSystemTime) {
        super(name, count);
        this.useSystemTimeOffset = useSystemTime;
        this.update();
    }

    @Override
    public double[] generateY(int count) {
        double[] retVal = new double[count];
        double period = (double)count / 10.0;
        double offset = this.useSystemTimeOffset ? (double)System.currentTimeMillis() / 1000.0 : 0.0;
        for (int i = 0; i < count; ++i) {
            double t = (double)i / period;
            retVal[i] = Math.sin(Math.PI * 2 * (t + 0.1 * offset));
        }
        return retVal;
    }
}

