/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public final class AssertUtils {
    private static final String MUST_BE_GREATER_THAN_OR_EQUAL_TO_0 = " must be greater than or equal to 0!";
    private static final String MUST_BE_NON_EMPTY = " must be non-empty!";

    private AssertUtils() {
    }

    public static <T> void notNull(String name, T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("The " + name + " must be non-null!");
        }
    }

    public static void indexInBounds(int index, int bounds) {
        AssertUtils.indexInBounds(index, bounds, "The index is out of bounds: 0 <= " + index + " < " + bounds);
    }

    public static void indexInBounds(int index, int bounds, String message) {
        if (index < 0 || index >= bounds) {
            throw new IndexOutOfBoundsException(message);
        }
    }

    public static void indexOrder(int index1, String name1, int index2, String name2) {
        if (index1 > index2) {
            throw new IndexOutOfBoundsException("Index " + name1 + "(" + index1 + ") is greated than index " + name2 + "(" + index2 + ")");
        }
    }

    public static void indexOrder(int index1, int index2, String msg) {
        if (index1 > index2) {
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public static <T extends Number> void gtThanZero(String name, T value) {
        if (value.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("The " + name + " must be greater than 0!");
        }
    }

    public static <T extends Number> void gtEqThanZero(String name, T value) {
        if (value.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static void equalDoubleArrays(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + array1.length + " vs. length2 = " + array2.length);
        }
    }

    public static void equalDoubleArrays(double[] array1, double[] array2, int nMinSize) {
        int length2;
        int length1 = Math.min(nMinSize, array1.length);
        if (length1 != (length2 = Math.min(nMinSize, array2.length))) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + array1.length + " vs. length2 = " + array2.length + " (nMinSize = " + nMinSize + ")");
        }
    }

    public static <T> void equalArrays(T[] array1, T[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("The double arrays must have the same length!");
        }
    }

    public static void equalFloatArrays(float[] array1, float[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("The float arrays must have the same length! length1 = " + array1.length + " vs. length2 = " + array2.length);
        }
    }

    public static void equalFloatArrays(float[] array1, float[] array2, int nMinSize) {
        int length2;
        int length1 = Math.min(nMinSize, array1.length);
        if (length1 != (length2 = Math.min(nMinSize, array2.length))) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + array1.length + " vs. length2 = " + array2.length + " (nMinSize = " + nMinSize + ")");
        }
    }

    public static void nonEmptyArray(String name, Object[] array) {
        AssertUtils.notNull(name, array);
        if (array.length == 0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_NON_EMPTY);
        }
        for (Object element : array) {
            if (element != null) continue;
            throw new NullPointerException("Elements of the " + name + " must be non-null!");
        }
    }

    public static void nonEmptyArray(String name, double[] array) {
        AssertUtils.notNull(name, array);
        if (array.length == 0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String name, int[] array) {
        AssertUtils.notNull(name, array);
        if (array.length == 0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String name, boolean[] array) {
        AssertUtils.notNull(name, array);
        if (array.length == 0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_NON_EMPTY);
        }
    }

    public static void belongsToEnum(String name, int[] allowedElements, int value) {
        for (int allowedElement : allowedElements) {
            if (value != allowedElement) continue;
            return;
        }
        throw new IllegalArgumentException("The " + name + " has incorrect value!");
    }

    public static void assertType(Object obj, Class<?> type) {
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException("The argument has incorrect type. The correct type is " + type.getName());
        }
    }

    public static boolean areEqual(double v1, double v2) {
        return v1 != v1 && v2 != v2 || v1 == v2;
    }

    public static void gtThanZero(String name, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("The " + name + " must be greater than 0!");
        }
    }

    public static void gtEqThanZero(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static void gtEqThanZero(String name, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("The " + name + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static void checkArrayDimension(String name, double[] array, int defaultLength) {
        AssertUtils.notNull(name, array);
        AssertUtils.nonEmptyArray(name, array);
        if (array.length != defaultLength) {
            throw new IllegalArgumentException("The " + name + " double array must have a length of " + defaultLength);
        }
    }

    public static void checkArrayDimension(String name, int[] array, int defaultLength) {
        AssertUtils.notNull(name, array);
        AssertUtils.nonEmptyArray(name, array);
        if (array.length != defaultLength) {
            throw new IllegalArgumentException("The " + name + " int array must have a length of " + defaultLength);
        }
    }

    public static void checkArrayDimension(String name, boolean[] array, int defaultLength) {
        AssertUtils.notNull(name, array);
        AssertUtils.nonEmptyArray(name, array);
        if (array.length != defaultLength) {
            throw new IllegalArgumentException("The " + name + " boolean array must have a length of " + defaultLength);
        }
    }
}

