/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public class DoubleCircularBuffer {
    private final double[] elements;
    private final int capacity;
    private int writePos;
    private boolean flipped;

    public DoubleCircularBuffer(int capacity) {
        this.capacity = capacity;
        this.elements = new double[capacity];
        this.flipped = false;
    }

    public void reset() {
        this.writePos = 0;
        this.flipped = false;
    }

    public int available() {
        if (this.flipped) {
            return this.capacity;
        }
        return this.writePos;
    }

    public int remainingCapacity() {
        return this.available();
    }

    public boolean put(double element) {
        this.elements[this.writePos++] = element;
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return true;
    }

    public int put(double[] newElements, int length) {
        return this.put(newElements, 0, length);
    }

    public int put(double[] newElements, int startIndex, int length) {
        int lengthUpperHalf = this.capacity - this.writePos;
        if (length <= lengthUpperHalf) {
            System.arraycopy(newElements, startIndex, this.elements, this.writePos, length);
            this.writePos += length;
            if (this.writePos == this.capacity) {
                this.writePos = 0;
                this.flipped = true;
            }
            return this.writePos;
        }
        System.arraycopy(newElements, startIndex, this.elements, this.writePos, lengthUpperHalf);
        this.writePos = this.capacity - 1;
        this.writePos += lengthUpperHalf;
        if (this.writePos >= this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return this.put(newElements, startIndex + lengthUpperHalf, length - lengthUpperHalf);
    }

    public double get(int readPos) {
        int index;
        int n = index = this.flipped ? this.writePos + readPos : readPos;
        while (index >= this.capacity) {
            index -= this.capacity;
        }
        if (!this.flipped) {
            if (index >= 0) {
                return this.elements[index];
            }
            throw new IllegalArgumentException("writePos = '" + this.writePos + "' readPos = '" + readPos + "'/index = '" + index + "' is beyond circular buffer capacity limits = [0," + this.capacity + "]");
        }
        while (index < 0) {
            index += this.capacity;
        }
        while (index >= this.capacity) {
            index -= this.capacity;
        }
        return this.elements[index];
    }

    public double[] get(double[] into, int length) {
        return this.get(into, 0, length);
    }

    public double[] get(double[] into, int readPos, int length) {
        double[] retVal = into == null ? new double[length] : into;
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.get(i + readPos);
        }
        return retVal;
    }

    public static void main(String[] args) {
        int i;
        int bufferLength = 10;
        int fillBufferLength = 35;
        DoubleCircularBuffer buffer1 = new DoubleCircularBuffer(10);
        DoubleCircularBuffer buffer2 = new DoubleCircularBuffer(10);
        double[] input = new double[35];
        double[] output = new double[35];
        buffer1.put(-2.0);
        buffer1.put(-1.0);
        buffer2.put(-2.0);
        buffer2.put(-1.0);
        for (i = 0; i < 35; ++i) {
            buffer1.put(i);
            input[i] = i;
        }
        buffer2.put(input, 35);
        buffer2.get(output, 10);
        System.out.println("demo print-out");
        for (i = 0; i < 30; ++i) {
            System.out.println(String.format("buffer[1,2].get(%d) = [%2.0f,%2.0f,%2.0f]", i, buffer1.get(i), buffer2.get(i), output[i]));
        }
    }
}

