/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset;

import de.gsi.dataset.DataSet;

public interface DataSetError
extends DataSet {
    public ErrorType getErrorType();

    public double getXErrorNegative(int var1);

    default public double[] getXErrorsNegative() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getXErrorNegative(i);
        }
        return retValues;
    }

    public double getXErrorPositive(int var1);

    default public double[] getXErrorsPositive() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getXErrorPositive(i);
        }
        return retValues;
    }

    public double getYErrorNegative(int var1);

    default public double[] getYErrorsNegative() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getYErrorNegative(i);
        }
        return retValues;
    }

    public double getYErrorPositive(int var1);

    default public double[] getYErrorsPositive() {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getYErrorPositive(i);
        }
        return retValues;
    }

    default public double getXErrorNegative(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.getX(index2);
        if (x1 == x2) {
            return this.getXErrorNegative(index1);
        }
        double de1 = this.getXErrorNegative(index1);
        return de1 + (this.getXErrorNegative(index2) - de1) * (x - x1) / (x2 - x1);
    }

    default public double getXErrorPositive(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.getX(index2);
        if (x1 == x2) {
            return this.getXErrorPositive(index1);
        }
        double de1 = this.getXErrorPositive(index1);
        return de1 + (this.getXErrorPositive(index2) - de1) * (x - x1) / (x2 - x1);
    }

    default public double getYErrorNegative(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.getX(index2);
        if (x1 == x2) {
            return this.getYErrorNegative(index1);
        }
        double de1 = this.getYErrorNegative(index1);
        return de1 + (this.getYErrorNegative(index2) - de1) * (x - x1) / (x2 - x1);
    }

    default public double getYErrorPositive(double x) {
        int index1 = this.getXIndex(x);
        double x1 = this.getX(index1);
        double y1 = this.getY(index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.getY(index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.getX(index2);
        if (x1 == x2) {
            return this.getYErrorPositive(index1);
        }
        double de1 = this.getYErrorPositive(index1);
        return de1 + (de1 - this.getYErrorPositive(index1)) * (x - x1) / (x2 - x1);
    }

    public static enum ErrorType {
        NO_ERROR,
        X,
        Y,
        XY,
        X_ASYMMETRIC,
        Y_ASYMMETRIC,
        XY_ASYMMETRIC;


        boolean isAssymmetric() {
            switch (this) {
                case NO_ERROR: 
                case X: 
                case Y: 
                case XY: {
                    return false;
                }
            }
            return true;
        }
    }
}

