/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.Histogram;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractDataSet3D;
import de.gsi.dataset.spi.DataRange;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractHistogram
extends AbstractDataSet3D<AbstractHistogram>
implements Histogram {
    private final int dimension;
    private final int nBinsX;
    private final int nBinsY;
    private final int nBinsZ;
    private double[] xBins;
    private double[] zBins;
    private double[] yBins;
    private final boolean equidistant;
    private final double[] data;
    private final DataRange valueRange = new DataRange();
    private final DataRange xBinRange = new DataRange();
    private final DataRange yBinRange = new DataRange();
    private final DataRange zBinRange = new DataRange();
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();

    public AbstractHistogram(String name, int nBins, double minX, double maxX) {
        super(name);
        this.dimension = 1;
        this.nBinsX = nBins + 2;
        this.nBinsY = 0;
        this.nBinsZ = 0;
        this.data = new double[this.nBinsX];
        this.xRange.set(minX, maxX);
        this.yRange.set(0.0, 0.0);
        this.zRange.set(0.0, 0.0);
        this.xBinRange.set(minX, maxX);
        this.yBinRange.set(0.0, 0.0);
        this.zBinRange.set(0.0, 0.0);
        this.equidistant = true;
    }

    public AbstractHistogram(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY) {
        super(name);
        this.dimension = 1;
        this.nBinsX = nBinsX + 2;
        this.nBinsY = nBinsY + 2;
        this.nBinsZ = 0;
        this.data = new double[this.nBinsX * this.nBinsY];
        this.xRange.set(minX, maxX);
        this.yRange.set(minY, maxY);
        this.zRange.set(0.0, 0.0);
        this.xBinRange.set(minX, maxX);
        this.yBinRange.set(minY, maxY);
        this.zBinRange.set(0.0, 0.0);
        this.equidistant = true;
    }

    public AbstractHistogram(String name, double[] xBins) {
        super(name);
        this.dimension = 1;
        int nBins = xBins.length;
        this.nBinsX = nBins + 2;
        this.nBinsY = 0;
        this.nBinsZ = 0;
        this.data = new double[this.nBinsX];
        this.xBins = new double[this.nBinsX];
        this.yBins = new double[this.nBinsY];
        this.zBins = new double[this.nBinsZ];
        this.xBins[0] = -1.7976931348623157E308;
        this.xBins[this.nBinsX - 1] = Double.MAX_VALUE;
        double[] xBinsSorted = Arrays.copyOf(xBins, xBins.length);
        Arrays.sort(xBinsSorted);
        for (int i = 0; i < nBins; ++i) {
            this.xBins[i + 1] = xBinsSorted[i];
            this.xRange.add(xBinsSorted[i]);
            this.xBinRange.add(xBinsSorted[i]);
        }
        this.yRange.set(0.0, 0.0);
        this.zRange.set(0.0, 0.0);
        this.yBinRange.set(0.0, 0.0);
        this.zBinRange.set(0.0, 0.0);
        this.equidistant = false;
    }

    @Override
    public boolean isEquiDistant() {
        return this.equidistant;
    }

    public DataRange getValueRange() {
        return this.valueRange;
    }

    @Override
    public String addDataStyle(int index, String style) {
        String retVal = this.dataStyles.put(index, style);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    @Override
    public String removeStyle(int index) {
        String retVal = this.dataStyles.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int bin) {
        return this.dataStyles.get(bin);
    }

    @Override
    public String addDataLabel(int index, String label) {
        String retVal = this.dataLabels.put(index, label);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    @Override
    public String removeDataLabel(int index) {
        String retVal = this.dataLabels.remove(index);
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    @Override
    public double getBinContent(int bin) {
        return this.data[bin];
    }

    @Override
    public void addBinContent(int bin) {
        this.data[bin] = this.data[bin] + 1.0;
        this.valueRange.add(this.data[bin]);
    }

    @Override
    public void addBinContent(int bin, double w) {
        this.data[bin] = this.data[bin] + w;
        this.valueRange.add(this.data[bin]);
    }

    @Override
    public double getMinimum() {
        return this.valueRange.getMin();
    }

    @Override
    public double getMaximum() {
        return this.valueRange.getMax();
    }

    protected int findNextLargerIndex(double[] bin, double value) {
        for (int i = 1; i < bin.length; ++i) {
            if (!(value < bin[i])) continue;
            return i - 1;
        }
        return bin.length - 1;
    }

    @Override
    public int findBin(double x) {
        if (this.xBinRange.getLength() == 0.0) {
            return 0;
        }
        if (!this.xBinRange.contains(x)) {
            if (x < this.xBinRange.getMin()) {
                return 0;
            }
            return this.getNBinsX() - 1;
        }
        if (this.isEquiDistant()) {
            double diff = x - this.xBinRange.getMin();
            double delta = this.xBinRange.getLength() / (double)(this.getNBinsX() - 2);
            return (int)Math.round(diff / delta);
        }
        return this.findNextLargerIndex(this.xBins, x);
    }

    protected int findBinX(double x) {
        return this.findBin(x);
    }

    protected int findBinY(double y) {
        if (this.yBinRange.getLength() == 0.0) {
            return 0;
        }
        if (!this.yBinRange.contains(y)) {
            if (y < this.yBinRange.getMin()) {
                return 0;
            }
            return this.getNBinsY() - 1;
        }
        if (this.isEquiDistant()) {
            double diff = y - this.yBinRange.getMin();
            double delta = this.yBinRange.getLength() / (double)(this.getNBinsY() - 2);
            return (int)Math.round(diff / delta);
        }
        return this.findNextLargerIndex(this.yBins, y);
    }

    protected int findBinZ(double z) {
        if (this.zBinRange.getLength() == 0.0) {
            return 0;
        }
        if (!this.zBinRange.contains(z)) {
            if (z < this.zBinRange.getMin()) {
                return 0;
            }
            return this.getNBinsY() - 1;
        }
        if (this.isEquiDistant()) {
            double diff = z - this.zBinRange.getMin();
            double delta = this.zBinRange.getLength() / (double)(this.getNBinsZ() - 2);
            return (int)Math.round(diff / delta);
        }
        return this.findNextLargerIndex(this.zBins, z);
    }

    @Override
    public int findBin(double x, double y) {
        int indexX = this.findBinX(x);
        int indexY = this.findBinY(y);
        return this.getNBinsX() * indexY + indexX;
    }

    @Override
    public int findBin(double x, double y, double z) {
        int indexX = this.findBinX(x);
        int indexY = this.findBinY(y);
        int indexZ = this.findBinZ(z);
        return this.getNBinsX() * (indexY + this.getNBinsZ() * indexZ) + indexX;
    }

    @Override
    public double getBinCenterX(int binX) {
        if (this.xBinRange.getLength() == 0.0) {
            return this.xBinRange.getMin();
        }
        if (this.isEquiDistant()) {
            double delta = this.xBinRange.getLength() / (double)(this.getNBinsX() - 2);
            return this.xBinRange.getMin() + (double)(binX - 1) * delta;
        }
        return this.xBins[binX] + 0.5 * (this.xBins[binX + 1] - this.xBins[binX]);
    }

    @Override
    public double getBinCenterY(int binY) {
        if (this.yBinRange.getLength() == 0.0) {
            return this.yBinRange.getMin();
        }
        double delta = this.yBinRange.getLength() / (double)(this.getNBinsY() - 2);
        return this.yBinRange.getMin() + (double)(binY - 1) * delta;
    }

    @Override
    public double getBinCenterZ(int binZ) {
        if (this.zBinRange.getLength() == 0.0) {
            return this.zBinRange.getMin();
        }
        double delta = this.zBinRange.getLength() / (double)(this.getNBinsZ() - 2);
        return this.zBinRange.getMin() + (double)(binZ - 1) * delta;
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.dataStyles.clear();
        this.dataLabels.clear();
        this.valueRange.empty();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getNBinsX() {
        return this.nBinsX;
    }

    @Override
    public int getNBinsY() {
        return this.nBinsY;
    }

    @Override
    public int getNBinsZ() {
        return this.nBinsZ;
    }

    @Override
    public void set(int xIndex, int yIndex, double x, double y, double z) {
    }
}

