/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DataSetBuilder {
    protected String name;
    protected double[] xValues;
    protected double[] yValues;
    protected double[] xErrorsPos;
    protected double[] xErrorsNeg;
    protected double[] yErrorsPos;
    protected double[] yErrorsNeg;
    protected ArrayList<String> infoList = new ArrayList();
    protected ArrayList<String> warningList = new ArrayList();
    protected ArrayList<String> errorList = new ArrayList();
    protected HashMap<String, String> metaInfoMap = new HashMap();
    protected HashMap<Integer, String> dataLabels = new HashMap();
    protected HashMap<Integer, String> dataStyles = new HashMap();
    protected double xMin = Double.NaN;
    protected double xMax = Double.NaN;
    protected double yMin = Double.NaN;
    protected double yMax = Double.NaN;
    protected int initialCapacity = -1;

    public DataSetBuilder() {
        this("default data set");
    }

    public DataSetBuilder(String dataSetName) {
        this.setName(dataSetName);
    }

    public final DataSetBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public final DataSetBuilder setXValuesNoCopy(double[] xValues) {
        this.xValues = xValues;
        return this;
    }

    public final DataSetBuilder setXValues(double[] xValues) {
        int size = this.initialCapacity < 0 ? xValues.length : Math.min(this.initialCapacity, xValues.length);
        this.xValues = new double[size];
        System.arraycopy(xValues, 0, this.xValues, 0, size);
        return this;
    }

    public final DataSetBuilder setYValuesNoCopy(double[] yValues) {
        this.yValues = yValues;
        return this;
    }

    public final DataSetBuilder setYValues(double[] yValues) {
        int size = this.initialCapacity < 0 ? yValues.length : Math.min(this.initialCapacity, yValues.length);
        this.yValues = new double[size];
        System.arraycopy(yValues, 0, this.yValues, 0, size);
        return this;
    }

    public final DataSetBuilder setXPosErrorNoCopy(double[] xErrorValuesPos) {
        this.xErrorsPos = xErrorValuesPos;
        return this;
    }

    public final DataSetBuilder setXPosError(double[] xErrorValuesPos) {
        int size = this.initialCapacity < 0 ? xErrorValuesPos.length : Math.min(this.initialCapacity, xErrorValuesPos.length);
        this.xErrorsPos = new double[size];
        System.arraycopy(xErrorValuesPos, 0, this.xErrorsPos, 0, size);
        return this;
    }

    public DataSetBuilder setXNegErrorNoCopy(double[] xErrorValuesNeg) {
        this.yErrorsNeg = xErrorValuesNeg;
        return this;
    }

    public DataSetBuilder setXNegError(double[] xErrorValuesNeg) {
        int size = this.initialCapacity < 0 ? xErrorValuesNeg.length : Math.min(this.initialCapacity, xErrorValuesNeg.length);
        this.xErrorsNeg = new double[size];
        System.arraycopy(xErrorValuesNeg, 0, this.xErrorsNeg, 0, size);
        return this;
    }

    public final DataSetBuilder setYPosErrorNoCopy(double[] yErrorValuesPos) {
        this.yErrorsPos = yErrorValuesPos;
        return this;
    }

    public final DataSetBuilder setYPosError(double[] yErrorValuesPos) {
        int size = this.initialCapacity < 0 ? yErrorValuesPos.length : Math.min(this.initialCapacity, yErrorValuesPos.length);
        this.yErrorsPos = new double[size];
        System.arraycopy(yErrorValuesPos, 0, this.yErrorsPos, 0, size);
        return this;
    }

    public DataSetBuilder setYNegErrorNoCopy(double[] yErrorValuesNeg) {
        this.yErrorsNeg = yErrorValuesNeg;
        return this;
    }

    public DataSetBuilder setYNegError(double[] yErrorValuesNeg) {
        int size = this.initialCapacity < 0 ? yErrorValuesNeg.length : Math.min(this.initialCapacity, yErrorValuesNeg.length);
        this.yErrorsNeg = new double[size];
        System.arraycopy(yErrorValuesNeg, 0, this.yErrorsNeg, 0, size);
        return this;
    }

    public DataSetBuilder setMetaInfoList(String[] infos) {
        this.infoList.addAll(Arrays.asList(infos));
        return this;
    }

    public DataSetBuilder setMetaWarningList(String[] warning) {
        this.warningList.addAll(Arrays.asList(warning));
        return this;
    }

    public DataSetBuilder setMetaErrorList(String[] errors) {
        this.errorList.addAll(Arrays.asList(errors));
        return this;
    }

    public DataSetBuilder setMetaInfoMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        this.metaInfoMap.putAll(map);
        return this;
    }

    public DataSetBuilder setDataLabelMap(Map<Integer, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        this.dataLabels.putAll(map);
        return this;
    }

    public DataSetBuilder setDataStyleMap(Map<Integer, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        this.dataStyles.putAll(map);
        return this;
    }

    public DataSetBuilder setXMin(double value) {
        this.xMin = value;
        return this;
    }

    public DataSetBuilder setXMax(double value) {
        this.xMax = value;
        return this;
    }

    public DataSetBuilder setYMin(double value) {
        this.yMin = value;
        return this;
    }

    public DataSetBuilder setYMax(double value) {
        this.yMax = value;
        return this;
    }

    protected DefaultDataSet buildWithYArrayOnly(String dsName) {
        int size = this.initialCapacity < 0 ? this.yValues.length : Math.min(this.yValues.length, this.initialCapacity);
        double[] dsX = new double[size];
        for (int i = 0; i < size; ++i) {
            dsX[i] = i;
        }
        return new DefaultDataSet(dsName, dsX, this.yValues, size, false);
    }

    protected DefaultErrorDataSet buildWithYErrors(String dsName, int size) {
        double[] dsYep = this.yErrorsPos == null ? this.yErrorsNeg : this.yErrorsPos;
        double[] dsYen = this.yErrorsNeg == null ? this.yErrorsPos : this.yErrorsNeg;
        AssertUtils.equalDoubleArrays(this.xValues, this.yErrorsPos, size);
        AssertUtils.equalDoubleArrays(this.xValues, this.yErrorsNeg, size);
        return new DefaultErrorDataSet(dsName, this.xValues, this.yValues, dsYen, dsYep, size, false);
    }

    protected DataSet buildRawDataSet(String dsName) {
        AbstractDataSet dataSet;
        if (this.xValues == null && this.yValues == null) {
            dataSet = new DefaultDataSet(dsName, Math.max(this.initialCapacity, 0));
        } else if (this.xValues == null) {
            dataSet = this.buildWithYArrayOnly(dsName);
        } else if (this.yErrorsNeg == null && this.yErrorsPos == null) {
            int minArrays = Math.min(this.xValues.length, this.yValues.length);
            int size = this.initialCapacity < 0 ? minArrays : Math.min(minArrays, this.initialCapacity);
            dataSet = new DefaultDataSet(dsName, this.xValues, this.yValues, size, false);
        } else {
            int minArrays = Math.min(this.xValues.length, this.yValues.length);
            int size = this.initialCapacity < 0 ? minArrays : Math.min(minArrays, this.initialCapacity);
            dataSet = this.buildWithYErrors(dsName, size);
        }
        return dataSet;
    }

    protected void addMetaData(DataSet dataSet) {
        if (!(dataSet instanceof AbstractDataSet)) {
            return;
        }
        AbstractDataSet ds = (AbstractDataSet)dataSet;
        ds.getInfoList().addAll(this.infoList);
        ds.getWarningList().addAll(this.warningList);
        ds.getErrorList().addAll(this.errorList);
    }

    protected void addDataRanges(DataSet dataSet) {
        if (!(dataSet instanceof AbstractDataSet)) {
            return;
        }
        AbstractDataSet ds = (AbstractDataSet)dataSet;
        ds.getXRange().set(this.xMin, this.xMax);
        ds.getYRange().set(this.yMin, this.yMax);
        if (ds.getXRange().isDefined() && ds.getYRange().isDefined()) {
            return;
        }
        ds.computeLimits();
    }

    protected void addDataLabelStyleMap(DataSet dataSet) {
        if (!(dataSet instanceof AbstractDataSet)) {
            return;
        }
        AbstractDataSet ds = (AbstractDataSet)dataSet;
        if (!this.dataLabels.isEmpty()) {
            this.dataLabels.forEach(ds::addDataLabel);
        }
        if (!this.dataStyles.isEmpty()) {
            this.dataStyles.forEach(ds::addDataStyle);
        }
    }

    public DataSet build() {
        Object dsName = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        DataSet dataSet = this.buildRawDataSet((String)dsName);
        this.addMetaData(dataSet);
        this.addDataRanges(dataSet);
        this.addDataLabelStyleMap(dataSet);
        return dataSet;
    }
}

