/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.LabelledMarker;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LabelledMarkerDataSet
extends AbstractDataSet<LabelledMarkerDataSet>
implements DataSet {
    protected ArrayList<String> dataLabels = new ArrayList();
    protected ArrayList<String> dataStyles = new ArrayList();
    protected ArrayList<DoublePoint> data = new ArrayList();

    public LabelledMarkerDataSet(String name) {
        super(name);
    }

    public List<String> getDataLabels() {
        return this.dataLabels;
    }

    public List<String> getDataStyles() {
        return this.dataStyles;
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    public LabelledMarkerDataSet clearData() {
        ((LabelledMarkerDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.dataLabels.clear();
        this.dataStyles.clear();
        this.xRange.empty();
        this.yRange.empty();
        return (LabelledMarkerDataSet)((LabelledMarkerDataSet)((LabelledMarkerDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this, "clear"));
    }

    @Override
    public double getX(int index) {
        return this.data.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.data.get(index).getY();
    }

    public LabelledMarkerDataSet add(LabelledMarker marker) {
        AssertUtils.notNull("marker", marker);
        this.lock();
        try {
            this.data.add(new DoublePoint(marker.getX(), marker.getY()));
            this.xRange.add(marker.getX());
            this.dataLabels.add(marker.getLabel());
            this.dataStyles.add(marker.getStyle());
        }
        finally {
            this.unlock();
        }
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelledMarkerDataSet set(List<LabelledMarker> markers) {
        AssertUtils.notNull("markers", markers);
        this.lock();
        try {
            this.setAutoNotifaction(false);
            this.data.clear();
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.xRange.empty();
            this.yRange.empty();
            for (LabelledMarker marker : markers) {
                double x = marker.getX();
                double y = marker.getY();
                this.data.add(new DoublePoint(x, y));
                this.xRange.add(x);
                this.dataLabels.add(marker.getLabel());
                this.dataStyles.add(marker.getStyle());
            }
            this.setAutoNotifaction(true);
        }
        finally {
            this.unlock();
        }
        this.fireInvalidated(new UpdatedDataEvent(this, "fill"));
        return this;
    }

    public LabelledMarkerDataSet set(LabelledMarker[] markers) {
        AssertUtils.notNull("markers", markers);
        return this.set(Arrays.asList(markers));
    }

    public LabelledMarkerDataSet set(int index, LabelledMarker marker) {
        AssertUtils.indexInBounds(index, this.getDataCount());
        this.lock();
        try {
            this.data.get(index).set(marker.getX(), marker.getY());
            this.xRange.add(marker.getX());
            this.dataLabels.set(index, marker.getLabel());
            this.dataStyles.set(index, marker.getStyle());
        }
        finally {
            this.unlock();
        }
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public LabelledMarkerDataSet remove(int fromIndex, int toIndex) {
        ((LabelledMarkerDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.data.subList(fromIndex, toIndex).clear();
        this.dataLabels.subList(fromIndex, toIndex).clear();
        this.dataStyles.subList(fromIndex, toIndex).clear();
        this.xRange.empty();
        this.yRange.empty();
        return (LabelledMarkerDataSet)((LabelledMarkerDataSet)((LabelledMarkerDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    @Override
    protected LabelledMarkerDataSet computeLimits() {
        this.lock();
        this.xRange.empty();
        this.yRange.empty();
        int dataCount = this.getDataCount();
        for (int i = 0; i < dataCount; ++i) {
            this.xRange.add(this.getX(i));
        }
        return (LabelledMarkerDataSet)this.unlock();
    }
}

