/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.spi.utils.Tuple;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ListDataSet
extends AbstractDataSet<ListDataSet>
implements DataSet {
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected ArrayList<DoublePoint> data = new ArrayList();

    public ListDataSet(String name) {
        super(name);
    }

    public ListDataSet(String name, double[] yValues) {
        this(name);
        AssertUtils.notNull("Y data", yValues);
        Integer i = 0;
        while (i < yValues.length) {
            this.data.add(new DoublePoint((double)i, yValues[i]));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public ListDataSet(String name, double[] xValues, double[] yValues) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        Integer i = 0;
        while (i < yValues.length) {
            this.data.add(new DoublePoint(xValues[i], yValues[i]));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public ListDataSet(String name, List<DoublePoint> values) {
        this(name);
        AssertUtils.notNull("values", values);
        this.data.clear();
        this.data.addAll(values);
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    public ListDataSet clearData() {
        ((ListDataSet)this.lock()).setAutoNotifaction(false);
        this.data.clear();
        this.xRange.empty();
        this.yRange.empty();
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double getX(int index) {
        return this.data.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.data.get(index).getY();
    }

    public ListDataSet set(List<DoublePoint> values) {
        AssertUtils.notNull("values", values);
        this.lock();
        this.data.clear();
        this.data.addAll(values);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        this.computeLimits();
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public ListDataSet set(int index, double x, double y) {
        this.lock();
        AssertUtils.indexInBounds(index, this.getDataCount());
        this.data.get(index).set(x, y);
        this.xRange.add(x);
        this.yRange.add(y);
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public ListDataSet add(double x, double y) {
        this.lock();
        this.data.add(new DoublePoint(x, y));
        this.xRange.add(x);
        this.yRange.add(y);
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public ListDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.data.subList(fromIndex, toIndex).clear();
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    public ListDataSet remove(int[] indices) {
        this.lock();
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return (ListDataSet)this.unlock();
        }
        ArrayList<Tuple> tupleTobeRemovedReferences = new ArrayList<Tuple>();
        for (int indexToRemove : indices) {
            tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
        }
        this.data.removeAll(tupleTobeRemovedReferences);
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        super.computeLimits();
        return (ListDataSet)((ListDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public ListDataSet add(double[] xValues, double[] yValues) {
        ((ListDataSet)this.lock()).setAutoNotifaction(false);
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        this.data.clear();
        this.xRange.setMax(Double.NaN);
        this.yRange.setMax(Double.NaN);
        for (int i = 0; i < xValues.length; ++i) {
            this.data.add(new DoublePoint(xValues[i], yValues[i]));
            this.xRange.add(xValues[i]);
            this.yRange.add(yValues[i]);
        }
        return (ListDataSet)((ListDataSet)((ListDataSet)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public String addDataLabel(int index, String label) {
        this.lock();
        String retVal = this.dataLabels.put(index, label);
        ((ListDataSet)this.unlock()).fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    @Override
    public String removeDataLabel(int index) {
        this.lock();
        String retVal = this.dataLabels.remove(index);
        ((ListDataSet)this.unlock()).fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    @Override
    public String addDataStyle(int index, String style) {
        this.lock();
        String retVal = this.dataStyles.put(index, style);
        ((ListDataSet)this.unlock()).fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    @Override
    public String removeStyle(int index) {
        this.lock();
        String retVal = this.dataStyles.remove(index);
        ((ListDataSet)this.unlock()).fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }
}

