/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.DataSetUtilsHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtils
extends DataSetUtilsHelper {
    private static final int SWITCH_TO_BINARY_KEY = 254;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtils.class);
    private static final String DEFAULT_TIME_FORMAT = "yyyyMMdd_HHmmss";
    protected static boolean useFloat32BinaryStandard = true;

    private DataSetUtils() {
    }

    public static boolean useFloat32BinaryStandard() {
        return useFloat32BinaryStandard;
    }

    public static void setUseFloat32BinaryStandard(boolean state) {
        useFloat32BinaryStandard = state;
    }

    public static AbstractDataSet<?> copyDataSet(DataSet ds) {
        DefaultDataSet d = new DefaultDataSet(ds.getName());
        d.set(ds);
        return d;
    }

    public static double error(DataSet dataSet, ErrType eType, int index) {
        return DataSetUtils.error(dataSet, eType, index, 0.0, false);
    }

    public static double error(DataSet dataSet, ErrType eType, double x) {
        return DataSetUtils.error(dataSet, eType, -1, x, true);
    }

    protected static double error(DataSet dataSet, ErrType eType, int index, double x, boolean interpolate) {
        if (!(dataSet instanceof DataSetError)) {
            return 0.0;
        }
        DataSetError ds = (DataSetError)dataSet;
        if (interpolate) {
            switch (eType) {
                case EXN: {
                    return ds.getXErrorNegative(x);
                }
                case EXP: {
                    return ds.getXErrorPositive(x);
                }
                case EYN: {
                    return ds.getYErrorNegative(x);
                }
                case EYP: {
                    return ds.getYErrorPositive(x);
                }
            }
        } else {
            switch (eType) {
                case EXN: {
                    return ds.getXErrorNegative(index);
                }
                case EXP: {
                    return ds.getXErrorPositive(index);
                }
                case EYN: {
                    return ds.getYErrorNegative(index);
                }
                case EYP: {
                    return ds.getYErrorPositive(index);
                }
            }
        }
        return 0.0;
    }

    protected static double[] cropToLength(double[] in, int length) {
        if (in.length == length) {
            return in;
        }
        return Arrays.copyOf(in, length);
    }

    public static double[] errors(DataSet dataSet, ErrType eType) {
        int nDim = dataSet.getDataCount();
        if (!(dataSet instanceof DataSetError)) {
            return new double[nDim];
        }
        DataSetError ds = (DataSetError)dataSet;
        switch (eType) {
            case EXN: {
                return DataSetUtils.cropToLength(ds.getXErrorsNegative(), nDim);
            }
            case EXP: {
                return DataSetUtils.cropToLength(ds.getXErrorsPositive(), nDim);
            }
            case EYN: {
                return DataSetUtils.cropToLength(ds.getYErrorsNegative(), nDim);
            }
        }
        return DataSetUtils.cropToLength(ds.getYErrorsPositive(), nDim);
    }

    public static String getISODate(long timeMillis, String format) {
        long time = TimeUnit.MILLISECONDS.toMillis(timeMillis);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(tz);
        return df.format(new Date(time));
    }

    private static OutputStream openDatasetFileOutput(File file, Compression compression) throws IOException {
        switch (compression) {
            case NONE: {
                return Files.newOutputStream(file.toPath(), new OpenOption[0]);
            }
            case GZIP: {
                return new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            case ZIP: {
                ZipOutputStream zipOStream = new ZipOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                String filename = file.getName();
                String zipentryname = filename.toLowerCase(Locale.UK).endsWith(".zip") ? filename.substring(0, filename.length() - 4) : filename;
                zipOStream.putNextEntry(new ZipEntry(zipentryname));
                return zipOStream;
            }
        }
        throw new IllegalArgumentException("Unknown Compression format: " + compression.toString());
    }

    private static SplitCharByteInputStream openDatasetFileInput(File file, Compression compression) throws IOException {
        InputStream istream;
        switch (compression) {
            case ZIP: {
                ZipInputStream zipIStream = new ZipInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                if (zipIStream.getNextEntry() == null) {
                    throw new ZipException("Corrupt zip archive has no entries");
                }
                istream = zipIStream;
                break;
            }
            case GZIP: {
                istream = new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                break;
            }
            case NONE: {
                istream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                break;
            }
            default: {
                throw new IOException("Unimplemented Compression");
            }
        }
        return new SplitCharByteInputStream(new PushbackInputStream(istream, 8192));
    }

    public static String getFileName(DataSet dataSet, String fileName) {
        Pattern placeholder = Pattern.compile("\\{([^\\{\\}]*)\\}");
        Matcher matcher = placeholder.matcher(fileName);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String value;
            String[] substitutionparams = matcher.group(1).split(";");
            if (substitutionparams.length == 0) {
                throw new IllegalArgumentException("fileName contains empty placeholder: " + matcher.group());
            }
            switch (substitutionparams[0]) {
                case "systemTime": {
                    value = Long.toString(System.currentTimeMillis());
                    break;
                }
                case "dataSetName": {
                    value = dataSet.getName();
                    break;
                }
                case "xMin": {
                    value = Double.toString(dataSet.getXMin());
                    break;
                }
                case "xMax": {
                    value = Double.toString(dataSet.getXMax());
                    break;
                }
                case "yMin": {
                    value = Double.toString(dataSet.getYMin());
                    break;
                }
                case "yMax": {
                    value = Double.toString(dataSet.getYMax());
                    break;
                }
                default: {
                    if (!(dataSet instanceof DataSetMetaData)) {
                        throw new IllegalArgumentException("fileName placeholder references meta data but dataSet is not instanceof DataSetMetaData");
                    }
                    DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
                    value = metaDataSet.getMetaInfo().get(substitutionparams[0]);
                    if (value != null) break;
                    throw new IllegalArgumentException("fileName placeholder references nonexisting metaData field: " + substitutionparams[0]);
                }
            }
            if (substitutionparams.length != 1 && !substitutionparams[1].equals("string")) {
                switch (substitutionparams[1]) {
                    case "date": {
                        String format = substitutionparams.length < 3 ? DEFAULT_TIME_FORMAT : substitutionparams[2];
                        value = DataSetUtils.getISODate(Long.valueOf(value), format);
                        break;
                    }
                    case "int": 
                    case "long": {
                        String format = substitutionparams.length < 3 ? "%d" : substitutionparams[2];
                        value = String.format(format, Long.valueOf(value));
                        break;
                    }
                    case "float": 
                    case "double": {
                        String format = substitutionparams.length < 3 ? "%e" : substitutionparams[2];
                        value = String.format(format, Double.valueOf(value));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("fileName contains placeholder with illegal type: " + substitutionparams[1]);
                    }
                }
            }
            matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Compression evaluateAutoCompression(String fileName) {
        if (fileName.toLowerCase(Locale.UK).endsWith(".gz")) {
            return Compression.GZIP;
        }
        if (fileName.toLowerCase(Locale.UK).endsWith(".zip")) {
            return Compression.ZIP;
        }
        return Compression.NONE;
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, boolean binary) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, Compression.AUTO, binary);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, Compression.AUTO, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, Compression compression) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, fileName, compression, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String fileName, Compression compression, boolean binary) {
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null or empty");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName must not be null or empty");
        }
        try {
            String longFileName;
            block15: {
                String realFileName = DataSetUtils.getFileName(dataSet, fileName);
                longFileName = path.toFile() + "/" + realFileName;
                File file = new File(longFileName);
                if (file.getParentFile().mkdirs() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("needed to create directory for file: " + longFileName);
                }
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(8192);
                try (OutputStream outputfile = DataSetUtils.openDatasetFileOutput(file, compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(fileName) : compression);){
                    DataSetUtils.writeDataSetToByteArray(dataSet, byteOutput, binary, DataSetUtils.useFloat32BinaryStandard());
                    byteOutput.writeTo(outputfile);
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block15;
                    LOGGER.error("could not write to file: '" + fileName + "'", (Throwable)e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("write data set '" + dataSet.getName() + "' to " + longFileName);
            }
            return longFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("could not write to file: '" + fileName + "'", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDataSetToByteArray(DataSet dataSet, ByteArrayOutputStream byteOutput, boolean binary, boolean asFloat) {
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null or empty");
        }
        if (byteOutput == null) {
            throw new IllegalArgumentException("byteOutput must not be null or empty");
        }
        byteOutput.reset();
        try {
            dataSet.lock();
            byteOutput.write(("#file producer : " + DataSetUtils.class.getCanonicalName() + "\n").getBytes());
            DataSetUtils.writeHeaderDataToStream(byteOutput, dataSet);
            DataSetUtils.writeMetaDataToStream(byteOutput, dataSet);
            if (binary) {
                DataSetUtils.writeNumericBinaryDataToStream(byteOutput, dataSet, asFloat);
            } else {
                DataSetUtils.writeNumericDataToStream(byteOutput, dataSet);
            }
        }
        catch (IOException e) {
            LOGGER.error("could not write to ByteArrayOutputStream", (Throwable)e);
            byteOutput.reset();
        }
        finally {
            dataSet.unlock();
        }
    }

    private static void writeNumericBinaryDataToStream(OutputStream outputStream, DataSet dataSet, boolean asFloat) {
        int nsamples = dataSet.getDataCount();
        String nSampleString = Long.toString(nsamples);
        StringBuilder buffer = DataSetUtils.getCachedStringBuilder("binaryDataCacheBuilder", 250);
        buffer.append("$binary").append("\n");
        if (asFloat) {
            buffer.append("$x;float32[];").append(nSampleString).append("\n");
            buffer.append("$y;float32[];").append(nSampleString).append("\n");
            buffer.append("$eyn;float32[];").append(nSampleString).append("\n");
            buffer.append("$eyp;float32[];").append(nSampleString).append("\n");
        } else {
            buffer.append("$x;float64[];").append(nSampleString).append("\n");
            buffer.append("$y;float64[];").append(nSampleString).append("\n");
            buffer.append("$eyn;float64[];").append(nSampleString).append("\n");
            buffer.append("$eyp;float64[];").append(nSampleString).append("\n");
        }
        try {
            outputStream.write(buffer.toString().getBytes());
        }
        catch (IOException e) {
            LOGGER.error("WriteNumericDataToBinaryFile failed to write header description: ", (Throwable)e);
        }
        DataSetUtils.release("binaryDataCacheBuilder", buffer);
        try {
            outputStream.write(254);
            if (asFloat) {
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray("writeByteBuffer", 4 * nsamples);
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getXValues());
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getYValues());
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN));
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP));
                outputStream.write(byteBuffer.array());
                DataSetUtils.release("writeByteBuffer", byteBuffer);
            } else {
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray("writeByteBuffer", 8 * nsamples);
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getXValues());
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getYValues());
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN));
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP));
                outputStream.write(byteBuffer.array());
                DataSetUtils.release("writeByteBuffer", byteBuffer);
            }
        }
        catch (IOException e) {
            LOGGER.error("WriteNumericDataToBinaryFile failed to write binary body: ", (Throwable)e);
        }
    }

    protected static void writeHeaderDataToStream(OutputStream outputStream, DataSet dataSet) {
        block5: {
            try {
                StringBuilder buffer;
                block4: {
                    buffer = DataSetUtils.getCachedStringBuilder("headerDataCacheBuilder", 250);
                    buffer.append("#dataSetName : ").append(dataSet.getName()).append('\n');
                    buffer.append("#xMin : ").append(dataSet.getXMin()).append('\n');
                    buffer.append("#xMax : ").append(dataSet.getXMax()).append('\n');
                    buffer.append("#yMin : ").append(dataSet.getYMin()).append('\n');
                    buffer.append("#yMax : ").append(dataSet.getYMax()).append('\n');
                    try {
                        buffer.append("#integral : ").append(DataSetUtils.integralSimple(dataSet)).append('\n');
                        buffer.append("#mean : ").append(DataSetUtils.mean(dataSet.getYValues())).append('\n');
                        buffer.append("#rms : ").append(DataSetUtils.rootMeanSquare(dataSet.getYValues())).append('\n');
                    }
                    catch (Exception e) {
                        if (!LOGGER.isErrorEnabled()) break block4;
                        LOGGER.error("writeHeaderDataToFile - compute Math error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
                    }
                }
                outputStream.write(buffer.toString().getBytes());
                DataSetUtils.release("headerDataCacheBuilder", buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block5;
                LOGGER.error("writeHeaderDataToFile - error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    protected static void writeMetaDataToStream(OutputStream outputStream, DataSet dataSet) {
        block7: {
            if (!(dataSet instanceof DataSetMetaData)) {
                return;
            }
            DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
            try {
                StringBuilder buffer = DataSetUtils.getCachedStringBuilder("metaDataCacheBuilder", 1000);
                for (String info : metaDataSet.getInfoList()) {
                    buffer.append("#info : ").append(info).append('\n');
                }
                for (String warning : metaDataSet.getWarningList()) {
                    buffer.append("#warning : ").append(warning).append('\n');
                }
                for (String error : metaDataSet.getErrorList()) {
                    buffer.append("#error : ").append(error).append('\n');
                }
                Map<String, String> map = metaDataSet.getMetaInfo();
                for (String key : metaDataSet.getMetaInfo().keySet()) {
                    buffer.append("#metaKey -").append(key).append(" : ").append(map.get(key)).append('\n');
                }
                outputStream.write(buffer.toString().getBytes());
                DataSetUtils.release("metaDataCacheBuilder", buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("writeMetaDataToFile - error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    protected static void writeNumericDataToStream(OutputStream outputFile, DataSet dataSet) {
        block3: {
            try {
                int nSamples = dataSet.getDataCount();
                StringBuilder buffer = DataSetUtils.getCachedStringBuilder("numericDataCacheBuilder", Math.max(100, nSamples * 45));
                buffer.append("#nSamples : ").append(Integer.toString(nSamples)).append("\n").append("$index, x, y, eyn, eyp").append("\n");
                for (int i = 0; i < nSamples; ++i) {
                    buffer.append(i);
                    buffer.append(',');
                    buffer.append(dataSet.getX(i));
                    buffer.append(',');
                    buffer.append(dataSet.getY(i));
                    buffer.append(',');
                    buffer.append(DataSetUtils.error(dataSet, ErrType.EYN, i));
                    buffer.append(',');
                    buffer.append(DataSetUtils.error(dataSet, ErrType.EYP, i));
                    buffer.append('\n');
                }
                outputFile.write(buffer.toString().getBytes());
                DataSetUtils.release("numericDataCacheBuilder", buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("writeNumericDataToFile - error for dataSet = '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    protected static String getKey(String line, String replace) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" : ");
        if (split.length < 2) {
            return null;
        }
        return split[0].replaceAll(replace, "");
    }

    protected static String getValue(String line) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" : ");
        if (split.length < 2) {
            return null;
        }
        return split[1];
    }

    public static DataSet readDataSetFromFile(String fileName) {
        return DataSetUtils.readDataSetFromFile(fileName, Compression.AUTO);
    }

    public static DataSet readDataSetFromFile(String fileName, Compression compression) {
        DoubleErrorDataSet dataSet;
        block12: {
            if (fileName == null || fileName.isEmpty()) {
                throw new IllegalArgumentException("fileName must not be null or empty");
            }
            dataSet = null;
            try {
                File file = new File(fileName);
                try (SplitCharByteInputStream inputFile = DataSetUtils.openDatasetFileInput(file, compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(fileName) : compression);){
                    dataSet = DataSetUtils.readDataSetFromStream(inputFile);
                }
                catch (IOException e) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("could not open/parse file: '" + fileName + "'", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block12;
                LOGGER.error("could not open/parse file: '" + fileName + "'", (Throwable)e);
            }
        }
        return dataSet;
    }

    public static DoubleErrorDataSet readDataSetFromByteArray(byte[] byteArray) {
        DoubleErrorDataSet dataSet;
        block9: {
            if (byteArray == null || byteArray.length == 0) {
                throw new InvalidParameterException("null byteArray");
            }
            if (byteArray.length == 0) {
                throw new InvalidParameterException("byteArray with zero length");
            }
            dataSet = null;
            ByteArrayInputStream istream = new ByteArrayInputStream(byteArray);
            try (SplitCharByteInputStream inputFile = new SplitCharByteInputStream(new PushbackInputStream(istream, 8192));){
                dataSet = DataSetUtils.readDataSetFromStream(inputFile);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block9;
                LOGGER.error("could not open/parse byte array size = " + byteArray.length, (Throwable)e);
            }
        }
        return dataSet;
    }

    public static DoubleErrorDataSet readDataSetFromStream(SplitCharByteInputStream inputStream) {
        boolean binary = false;
        DoubleErrorDataSet dataSet = null;
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));){
            String dataSetName = "unknown data set";
            int nDataCountEstimate = 0;
            ArrayList<String> info = new ArrayList<String>();
            ArrayList<String> warning = new ArrayList<String>();
            ArrayList<String> error = new ArrayList<String>();
            ConcurrentHashMap<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();
            String line = inputReader.readLine();
            while ((line = inputReader.readLine()) != null) {
                if (line.contains("$")) {
                    if (!line.startsWith("$binary")) break;
                    binary = true;
                    break;
                }
                if (line.contains("#dataSetName")) {
                    dataSetName = DataSetUtils.getValue(line);
                }
                if (line.contains("#nSamples")) {
                    nDataCountEstimate = Integer.parseInt(DataSetUtils.getValue(line));
                }
                if (line.contains("#info")) {
                    info.add(DataSetUtils.getValue(line));
                }
                if (line.contains("#warning")) {
                    warning.add(DataSetUtils.getValue(line));
                }
                if (line.contains("#error")) {
                    error.add(DataSetUtils.getValue(line));
                }
                if (!line.contains("#metaKey -")) continue;
                String key = DataSetUtils.getKey(line, "#metaKey -");
                String value = DataSetUtils.getValue(line);
                metaInfoMap.put(key, value);
            }
            dataSet = new DoubleErrorDataSet(dataSetName, nDataCountEstimate);
            dataSet.getMetaInfo().putAll(metaInfoMap);
            dataSet.getInfoList();
            if (binary) {
                DataSetUtils.readNumericDataFromBinaryStream(inputReader, inputStream, dataSet);
            } else {
                DataSetUtils.readNumericDataFromReader(inputReader, dataSet);
            }
        }
        catch (IOException e) {
            LOGGER.error("could not open/parse inputStream", (Throwable)e);
            return dataSet;
        }
        return dataSet;
    }

    private static void readNumericDataFromBinaryStream(BufferedReader inputReader, SplitCharByteInputStream inputStream, DoubleErrorDataSet dataSet) throws IOException {
        String line;
        class DataEntry {
            public String name;
            public String type;
            public final int nsamples;
            public FloatBuffer data32;
            public DoubleBuffer data64;

            DataEntry(String name, String type, int nSamples) {
                this.name = name;
                this.type = type;
                this.nsamples = nSamples;
            }
        }
        ArrayList<DataEntry> toRead = new ArrayList<DataEntry>();
        while ((line = inputReader.readLine()) != null) {
            String[] tokens = line.substring(1).split(";");
            toRead.add(new DataEntry(tokens[0], tokens[1], Integer.valueOf(tokens[2])));
        }
        if (inputStream.reachedSplit()) {
            inputStream.switchToBinary();
            int[] valindex = new int[]{-1, -1, -1, -1};
            block13: for (int i = 0; i < toRead.size(); ++i) {
                int alreadyRead;
                boolean isFloat32;
                DataEntry dataentry = (DataEntry)toRead.get(i);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Read data: " + dataentry.name);
                }
                ByteBuffer byteData = (isFloat32 = dataentry.type.toLowerCase(Locale.UK).contains("float32")) ? ByteBuffer.allocate(dataentry.nsamples * 4) : ByteBuffer.allocate(dataentry.nsamples * 8);
                if (isFloat32) {
                    dataentry.data32 = byteData.asFloatBuffer();
                    for (alreadyRead = 0; alreadyRead < dataentry.nsamples * 4; alreadyRead += inputStream.read(byteData.array(), alreadyRead, dataentry.nsamples * 4 - alreadyRead)) {
                    }
                } else {
                    dataentry.data64 = byteData.asDoubleBuffer();
                    while (alreadyRead < dataentry.nsamples * 8) {
                        alreadyRead += inputStream.read(byteData.array(), alreadyRead, dataentry.nsamples * 8 - alreadyRead);
                    }
                }
                switch (dataentry.name) {
                    case "x": {
                        valindex[0] = i;
                        continue block13;
                    }
                    case "y": {
                        valindex[1] = i;
                        continue block13;
                    }
                    case "eyn": {
                        valindex[2] = i;
                        continue block13;
                    }
                    case "eyp": {
                        valindex[3] = i;
                        continue block13;
                    }
                    default: {
                        if (!LOGGER.isDebugEnabled()) continue block13;
                        LOGGER.debug("Got unused variable " + dataentry.name + " of type " + dataentry.type);
                    }
                }
            }
            double[] x = DataSetUtils.readDoubleArrayFromBuffer(((DataEntry)toRead.get((int)valindex[0])).data32, ((DataEntry)toRead.get((int)valindex[0])).data64);
            double[] y = DataSetUtils.readDoubleArrayFromBuffer(((DataEntry)toRead.get((int)valindex[1])).data32, ((DataEntry)toRead.get((int)valindex[1])).data64);
            double[] eyn = DataSetUtils.readDoubleArrayFromBuffer(((DataEntry)toRead.get((int)valindex[2])).data32, ((DataEntry)toRead.get((int)valindex[2])).data64);
            double[] eyp = DataSetUtils.readDoubleArrayFromBuffer(((DataEntry)toRead.get((int)valindex[3])).data32, ((DataEntry)toRead.get((int)valindex[3])).data64);
            dataSet.set(x, y, eyn, eyp, false);
        } else {
            LOGGER.error("File seems to be corrupted, Split marker not found");
        }
    }

    protected static void readNumericDataFromReader(BufferedReader inputReader, DoubleErrorDataSet dataSet) {
        block4: {
            try {
                String line = inputReader.readLine();
                while (line != null) {
                    String[] parse = line.split(",");
                    if (parse.length != 0) {
                        double x = Double.parseDouble(parse[1]);
                        double y = Double.parseDouble(parse[2]);
                        double eyn = parse.length < 5 ? 0.0 : Double.parseDouble(parse[3]);
                        double eyp = parse.length < 5 ? 0.0 : Double.parseDouble(parse[4]);
                        dataSet.add(x, y, eyn, eyp);
                    }
                    line = inputReader.readLine();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("readNumericDataFromFile could not parse numeric data for: '" + dataSet.getName() + "'", (Throwable)e);
            }
        }
    }

    private static class SplitCharByteInputStream
    extends FilterInputStream {
        private static final byte MARKER = -2;
        private boolean binary;
        private boolean hasMarker;
        private final PushbackInputStream pbin;

        public SplitCharByteInputStream(PushbackInputStream in) {
            super(in);
            this.pbin = in;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b == -2) {
                this.pbin.unread(b);
                b = -1;
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int nread;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                nread = this.in.read(b, 0, b.length);
            } else {
                nread = this.in.read(b, 0, b.length);
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != -2) continue;
                    this.pbin.unread(b, i + 1, nread - i - 1);
                    this.hasMarker = true;
                    return i;
                }
            }
            return nread;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nread;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                nread = this.in.read(b, off, len);
            } else {
                nread = this.in.read(b, off, len);
                for (int i = off; i < off + nread; ++i) {
                    if (b[i] != -2) continue;
                    this.pbin.unread(b, i + 1, off + nread - i - 1);
                    this.hasMarker = true;
                    return i;
                }
            }
            return nread;
        }

        public boolean reachedSplit() {
            return this.hasMarker && !this.binary;
        }

        public void switchToBinary() {
            if (this.hasMarker) {
                if (this.binary) {
                    LOGGER.warn("Allready in binary mode");
                } else {
                    this.binary = true;
                }
            } else {
                LOGGER.warn("Char/Byte split marker not reached yet");
            }
        }
    }

    public static enum Compression {
        AUTO,
        GZIP,
        ZIP,
        NONE;

    }

    public static enum ErrType {
        EXN,
        EXP,
        EYN,
        EYP;

    }
}

