/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.DataSet;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.security.InvalidParameterException;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class DataSetUtilsHelper {
    protected static final ReentrantLock BYTE_ARRAY_CACHE_LOCK = new ReentrantLock();
    protected static WeakHashMap<String, WeakHashMap<Integer, ByteBuffer>> byteArrayCache = new WeakHashMap();
    protected static final ReentrantLock STRING_BUFFER_CACHE_LOCK = new ReentrantLock();
    protected static WeakHashMap<String, WeakHashMap<Integer, StringBuilder>> stringBuilderCache = new WeakHashMap();

    protected static ByteBuffer getCachedDoubleArray(String arrayName, int size) {
        BYTE_ARRAY_CACHE_LOCK.lock();
        WeakHashMap arrayMap = byteArrayCache.computeIfAbsent(arrayName, name -> new WeakHashMap());
        ByteBuffer cachedArray = (ByteBuffer)arrayMap.get(size);
        if (cachedArray == null) {
            cachedArray = ByteBuffer.allocate(size);
        } else {
            byteArrayCache.get(arrayName).remove(cachedArray);
        }
        BYTE_ARRAY_CACHE_LOCK.unlock();
        return cachedArray;
    }

    protected static void release(String arrayName, ByteBuffer cachedArray) {
        if (cachedArray == null) {
            return;
        }
        BYTE_ARRAY_CACHE_LOCK.lock();
        byteArrayCache.get(arrayName).put(cachedArray.capacity(), cachedArray);
        BYTE_ARRAY_CACHE_LOCK.unlock();
    }

    protected static StringBuilder getCachedStringBuilder(String arrayName, int size) {
        STRING_BUFFER_CACHE_LOCK.lock();
        WeakHashMap arrayMap = stringBuilderCache.computeIfAbsent(arrayName, name -> new WeakHashMap());
        StringBuilder cachedArray = (StringBuilder)arrayMap.get(size);
        if (cachedArray == null) {
            cachedArray = new StringBuilder(size);
        } else {
            stringBuilderCache.get(arrayName).remove(cachedArray);
        }
        cachedArray.delete(0, cachedArray.length());
        STRING_BUFFER_CACHE_LOCK.unlock();
        return cachedArray;
    }

    protected static void release(String arrayName, StringBuilder cachedArray) {
        if (cachedArray == null) {
            return;
        }
        STRING_BUFFER_CACHE_LOCK.lock();
        stringBuilderCache.get(arrayName).put(cachedArray.capacity(), cachedArray);
        STRING_BUFFER_CACHE_LOCK.unlock();
    }

    public static float[] toFloatArray(double[] input) {
        if (input == null) {
            return null;
        }
        int n = input.length;
        float[] ret = new float[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = (float)input[i];
        }
        return ret;
    }

    public static double[] toDoubleArray(float[] input) {
        if (input == null) {
            return null;
        }
        int n = input.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = input[i];
        }
        return ret;
    }

    protected static void writeDoubleArrayToByteBuffer(ByteBuffer byteBuffer, double[] doubleBuffer) {
        if (byteBuffer == null) {
            throw new InvalidParameterException("ByteBuffer is 'null'");
        }
        if (doubleBuffer == null) {
            throw new InvalidParameterException("doubleBuffer is 'null'");
        }
        if (byteBuffer.capacity() < doubleBuffer.length * 8) {
            throw new InvalidParameterException("byte buffer size (" + byteBuffer.capacity() + ") is smaller than double buffer size (" + doubleBuffer.length + ")");
        }
        byteBuffer.position(0);
        for (int i = 0; i < doubleBuffer.length; ++i) {
            byteBuffer.putDouble(doubleBuffer[i]);
        }
    }

    protected static void writeDoubleArrayAsFloatToByteBuffer(ByteBuffer byteBuffer, double[] doubleBuffer) {
        if (byteBuffer == null) {
            throw new InvalidParameterException("ByteBuffer is 'null'");
        }
        if (doubleBuffer == null) {
            throw new InvalidParameterException("doubleBuffer is 'null'");
        }
        if (byteBuffer.capacity() < doubleBuffer.length * 4) {
            throw new InvalidParameterException("byte buffer size (" + byteBuffer.capacity() + ") is smaller than double buffer size (" + doubleBuffer.length * 4 + ")");
        }
        byteBuffer.position(0);
        for (int i = 0; i < doubleBuffer.length; ++i) {
            byteBuffer.putFloat((float)doubleBuffer[i]);
        }
    }

    protected static double[] readDoubleArrayFromBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (floatBuffer != null) {
            double[] retArray = new double[floatBuffer.limit()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = floatBuffer.get(i);
            }
            return retArray;
        }
        if (doubleBuffer != null) {
            double[] retArray = new double[doubleBuffer.limit()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = doubleBuffer.get(i);
            }
            return retArray;
        }
        throw new InvalidParameterException("floatBuffer and doubleBuffer must not both be null");
    }

    protected static double integralSimple(DataSet function) {
        double integral1 = 0.0;
        double integral2 = 0.0;
        if (function.getDataCount() <= 1) {
            return 0.0;
        }
        for (int i = 1; i < function.getDataCount(); ++i) {
            double step = function.getX(i) - function.getX(i - 1);
            double val1 = function.getY(i - 1);
            double val2 = function.getY(i);
            integral1 += step * val1;
            integral2 += step * val2;
        }
        return 0.5 * (integral1 + integral2);
    }

    protected static synchronized double mean(double[] data) {
        if (data.length <= 0) {
            return Double.NaN;
        }
        double norm = 1.0 / (double)data.length;
        double val = 0.0;
        for (int i = 0; i < data.length; ++i) {
            val += norm * data[i];
        }
        return val;
    }

    protected static synchronized double rootMeanSquare(double[] data) {
        if (data.length <= 0) {
            return Double.NaN;
        }
        double norm = 1.0 / (double)data.length;
        double val1 = 0.0;
        double val2 = 0.0;
        for (int i = 0; i < data.length; ++i) {
            val1 += data[i];
            val2 += data[i] * data[i];
        }
        return Math.sqrt(Math.abs((val2 *= norm) - (val1 *= norm) * val1));
    }
}

