/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FifoDoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError {
    private static final Logger LOGGER = LoggerFactory.getLogger(FifoDoubleErrorDataSet.class);
    protected LimitedQueue<DataBlob> data;
    protected double maxDistance = Double.MAX_VALUE;

    public FifoDoubleErrorDataSet(String name, int initalSize) {
        this(name, initalSize, Double.MAX_VALUE);
    }

    public FifoDoubleErrorDataSet(String name, int initalSize, double maxDistance) {
        super(name);
        if (initalSize <= 0) {
            throw new IllegalArgumentException("negative or zero initalSize = " + initalSize);
        }
        if (maxDistance <= 0.0) {
            throw new IllegalArgumentException("negative or zero maxDistance = " + maxDistance);
        }
        this.maxDistance = maxDistance;
        this.data = new LimitedQueue(initalSize);
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public double getX(int index) {
        return ((DataBlob)this.data.get(index)).getX();
    }

    @Override
    public double getY(int index) {
        return ((DataBlob)this.data.get(index)).getY();
    }

    @Override
    public String getStyle(int index) {
        return ((DataBlob)this.data.get(index)).getStyle();
    }

    @Override
    public double getXErrorNegative(int index) {
        return ((DataBlob)this.data.get(index)).getErrorX();
    }

    @Override
    public double getXErrorPositive(int index) {
        return ((DataBlob)this.data.get(index)).getErrorX();
    }

    @Override
    public double getYErrorNegative(int index) {
        return ((DataBlob)this.data.get(index)).getErrorY();
    }

    @Override
    public double getYErrorPositive(int index) {
        return ((DataBlob)this.data.get(index)).getErrorY();
    }

    @Override
    public String getDataLabel(int index) {
        return ((DataBlob)this.data.get(index)).getDataLabel();
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag) {
        return this.add(x, y, yErrorNeg, yErrorPos, tag, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag, String style) {
        this.lock();
        boolean notifyState = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.data.add(new DataBlob(x, y, yErrorNeg, yErrorPos, tag, style));
        this.expire(x);
        this.setAutoNotifaction(notifyState);
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public FifoDoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        this.lock();
        boolean notifyState = this.isAutoNotification();
        this.setAutoNotifaction(!notifyState);
        for (int i = 0; i < xValues.length; ++i) {
            this.add(xValues[i], yValues[i], yErrorsNeg[i], yErrorsPos[i]);
        }
        this.setAutoNotifaction(notifyState);
        this.unlock();
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public int expire(double now) {
        this.lock();
        this.xRange.empty();
        this.yRange.empty();
        ArrayList<DataBlob> toRemoveList = new ArrayList<DataBlob>();
        for (DataBlob blob : this.data) {
            double x = blob.getX();
            double y = blob.getX();
            if (Double.isFinite(x) && Double.isFinite(y)) {
                if (Math.abs(now - x) > this.maxDistance) {
                    toRemoveList.add(blob);
                    continue;
                }
                this.xRange.add(x + blob.getErrorX());
                this.xRange.add(x - blob.getErrorX());
                this.xRange.add(y + blob.getErrorY());
                this.xRange.add(y - blob.getErrorY());
                continue;
            }
            toRemoveList.add(blob);
        }
        this.data.removeAll(toRemoveList);
        this.computeLimits();
        int dataPointsToRemove = toRemoveList.size();
        this.unlock();
        if (dataPointsToRemove != 0) {
            this.fireInvalidated(new RemovedDataEvent(this, "expired data"));
        }
        return dataPointsToRemove;
    }

    public void reset() {
        this.data.clear();
        this.fireInvalidated(new RemovedDataEvent(this, "reset"));
    }

    protected class DataBlob
    extends DoublePointError {
        String style;
        String tag;

        DataBlob(double x, double y, double errorX, double errorY, String tag, String style) {
            super(x, y, errorX, errorY);
            this.tag = tag;
            this.style = style;
        }

        DataBlob(double x, double y, double errorX, double errorY) {
            this(x, y, errorX, errorY, null, null);
        }

        public String getStyle() {
            return this.style;
        }

        public String getDataLabel() {
            return this.tag;
        }
    }

    public class LimitedQueue<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -5751322669709687363L;
        private final int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
            if (limit < 1) {
                throw new IllegalArgumentException("Queue limit must be greater than 0");
            }
        }

        @Override
        public boolean add(E o) {
            boolean r = super.add(o);
            if (this.size() > this.limit) {
                super.remove(0);
            }
            return r;
        }
    }
}

