/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;

public class WrappedDataSet
extends AbstractDataSet<WrappedDataSet> {
    private DataSet dataset;
    private final EventListener listener = s -> this.datasetInvalidated();

    public WrappedDataSet(String name) {
        super(name);
    }

    @Override
    public String getName() {
        if (this.dataset != null) {
            return this.dataset.getName();
        }
        return super.getName();
    }

    public void setDataset(DataSet dataset) {
        if (this.dataset != null) {
            this.dataset.removeListener(this.listener);
        }
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.addListener(this.listener);
        }
        this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    @Override
    public int getDataCount() {
        return this.dataset == null ? 0 : this.dataset.getDataCount();
    }

    @Override
    public int getDataCount(double xmin, double xmax) {
        return this.dataset == null ? 0 : this.dataset.getDataCount(xmin, xmax);
    }

    @Override
    public double getX(int i) {
        return this.dataset == null ? 0.0 : this.dataset.getX(i);
    }

    @Override
    public double getY(int i) {
        return this.dataset == null ? 0.0 : this.dataset.getY(i);
    }

    @Override
    public int getXIndex(double x) {
        return this.dataset == null ? 0 : this.dataset.getXIndex(x);
    }

    @Override
    public double getXMin() {
        return this.dataset == null ? 0.0 : this.dataset.getXMin();
    }

    @Override
    public double getXMax() {
        return this.dataset == null ? 0.0 : this.dataset.getXMax();
    }

    @Override
    public double getYMin() {
        return this.dataset == null ? 0.0 : this.dataset.getYMin();
    }

    @Override
    public double getYMax() {
        return this.dataset == null ? 0.0 : this.dataset.getYMax();
    }

    private void datasetInvalidated() {
        this.computeLimits();
        this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public String getStyle(int index) {
        return this.dataset == null ? null : this.dataset.getStyle(index);
    }
}

