/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.serializer;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.serializer.DataType;
import de.gsi.dataset.utils.serializer.FastByteBuffer;
import de.gsi.dataset.utils.serializer.GenericsHelper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class BinarySerialiser {
    private static final String READ_POSITION_AT_BUFFER_END = "read position at buffer end";
    public static final byte VERSION_MAJOR = 1;
    public static final byte VERSION_MINOR = 0;
    public static final byte VERSION_MICRO = 0;
    protected static final BinarySerialiser SELF;
    protected static HeaderInfo headerThis;
    private static int bufferIncrements;

    protected BinarySerialiser() {
    }

    public static int getBufferIncrements() {
        return bufferIncrements;
    }

    public static void setBufferIncrements(int bufferIncrements) {
        AssertUtils.gtEqThanZero("bufferIncrements", bufferIncrements);
        BinarySerialiser.bufferIncrements = bufferIncrements;
    }

    public static void putHeaderInfo(FastByteBuffer buffer) {
        AssertUtils.notNull("buffer", buffer);
        buffer.putString("#file producer : ");
        buffer.putString(BinarySerialiser.class.getCanonicalName());
        buffer.putString("\n");
        buffer.putByte((byte)1);
        buffer.putByte((byte)0);
        buffer.putByte((byte)0);
    }

    protected static void putFieldHeader(FastByteBuffer buffer, String fieldName, DataType dataType) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, dataType, 0);
    }

    protected static void putFieldHeader(FastByteBuffer buffer, String fieldName, DataType dataType, int additionalSize) {
        AssertUtils.notNull("buffer", buffer);
        AssertUtils.notNull("fieldName", fieldName);
        buffer.ensureAdditionalCapacity((long)fieldName.length() + 1L + 2L + (long)bufferIncrements + dataType.getPrimitiveSize() + (long)additionalSize);
        buffer.putString(fieldName);
        buffer.putByte(dataType.getAsByte());
    }

    public static void putEndMarker(FastByteBuffer buffer) {
        BinarySerialiser.putFieldHeader(buffer, DataType.END_MARKER.getAsString(), DataType.END_MARKER);
        buffer.putByte(DataType.END_MARKER.getAsByte());
    }

    public static void put(FastByteBuffer buffer, String fieldName, boolean value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.BOOL);
        buffer.putBoolean(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, byte value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.BYTE);
        buffer.putByte(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, short value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.SHORT);
        buffer.putShort(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, int value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.INT);
        buffer.putInt(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, long value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.LONG);
        buffer.putLong(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, float value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.FLOAT);
        buffer.putFloat(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, double value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.DOUBLE);
        buffer.putDouble(value);
    }

    public static void put(FastByteBuffer buffer, String fieldName, String value) {
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.STRING, (value == null ? 1 : value.length()) + 1);
        buffer.putString(value == null ? "" : value);
    }

    private static int getNumberOfElements(int[] dimensions) {
        AssertUtils.notNull("dimensions", dimensions);
        int ret = 1;
        for (int i = 0; i < dimensions.length; ++i) {
            int dim = dimensions[i];
            AssertUtils.gtThanZero("dimensions[" + i + "]", dim);
            ret *= dim;
        }
        return ret;
    }

    protected static int putArrayHeader(FastByteBuffer buffer, String fieldName, DataType dataType, int[] dims) {
        AssertUtils.notNull("dims", dims);
        int nElements = BinarySerialiser.getNumberOfElements(dims);
        int addBufferSize = dims.length * 4 + nElements * (int)dataType.getPrimitiveSize() + 5;
        BinarySerialiser.putFieldHeader(buffer, fieldName, dataType, addBufferSize);
        buffer.putInt(dims.length);
        for (int i = 0; i < dims.length; ++i) {
            buffer.putInt(dims[i]);
        }
        return nElements;
    }

    public static void put(FastByteBuffer buffer, String fieldName, boolean[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, boolean[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.BOOL_ARRAY, dims);
        buffer.putBooleanArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, byte[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, byte[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.BYTE_ARRAY, dims);
        buffer.putByteArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, short[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, short[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.SHORT_ARRAY, dims);
        buffer.putShortArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, int[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, int[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.INT_ARRAY, dims);
        buffer.putIntArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, long[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, long[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.LONG_ARRAY, dims);
        buffer.putLongArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, float[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, float[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.FLOAT_ARRAY, dims);
        buffer.putFloatArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, double[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, double[] arrayValue, int[] dims) {
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.DOUBLE_ARRAY, dims);
        buffer.putDoubleArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    public static void put(FastByteBuffer buffer, String fieldName, String[] arrayValue) {
        BinarySerialiser.put(buffer, fieldName, arrayValue, new int[]{arrayValue.length});
    }

    public static void put(FastByteBuffer buffer, String fieldName, String[] arrayValue, int[] dims) {
        if (arrayValue == null || arrayValue.length == 0) {
            return;
        }
        int nElements = BinarySerialiser.putArrayHeader(buffer, fieldName, DataType.STRING_ARRAY, dims);
        buffer.putStringArray(arrayValue, Math.min(nElements, arrayValue.length));
    }

    protected static void putGenericArrayAsPrimitive(FastByteBuffer buffer, DataType dataType, Object[] data, int nToCopy) {
        switch (dataType) {
            case BOOL: {
                buffer.putBooleanArray(GenericsHelper.toBoolPrimitive((Boolean[])data), nToCopy);
                break;
            }
            case BYTE: {
                buffer.putByteArray(GenericsHelper.toBytePrimitive(data), nToCopy);
                break;
            }
            case SHORT: {
                buffer.putShortArray(GenericsHelper.toShortPrimitive(data), nToCopy);
                break;
            }
            case INT: {
                buffer.putIntArray(GenericsHelper.toIntegerPrimitive(data), nToCopy);
                break;
            }
            case LONG: {
                buffer.putLongArray(GenericsHelper.toLongPrimitive(data), nToCopy);
                break;
            }
            case FLOAT: {
                buffer.putFloatArray(GenericsHelper.toFloatPrimitive(data), nToCopy);
                break;
            }
            case DOUBLE: {
                buffer.putDoubleArray(GenericsHelper.toDoublePrimitive(data), nToCopy);
                break;
            }
            case STRING: {
                buffer.putStringArray(GenericsHelper.toStringPrimitive(data), nToCopy);
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + data[0].getClass().getSimpleName());
            }
        }
    }

    public static <K, V> void put(FastByteBuffer buffer, String fieldName, Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Object[] keySet = map.keySet().toArray();
        Object[] valueSet = map.values().toArray();
        int nElements = keySet.length;
        DataType keyDataType = DataType.fromClassType(keySet[0].getClass());
        DataType valueDataType = DataType.fromClassType(valueSet[0].getClass());
        int entrySize = 16;
        BinarySerialiser.putFieldHeader(buffer, fieldName, DataType.MAP, nElements * 16 + 5);
        buffer.putInt(1);
        buffer.putInt(nElements);
        buffer.putByte(keyDataType.getAsByte());
        buffer.putByte(valueDataType.getAsByte());
        BinarySerialiser.putGenericArrayAsPrimitive(buffer, keyDataType, keySet, nElements);
        BinarySerialiser.putGenericArrayAsPrimitive(buffer, valueDataType, valueSet, nElements);
    }

    public static HeaderInfo checkHeaderInfo(FastByteBuffer readBuffer) {
        AssertUtils.notNull("readBuffer", readBuffer);
        readBuffer.getString();
        String producer = readBuffer.getString();
        readBuffer.getString();
        byte major = readBuffer.getByte();
        byte minor = readBuffer.getByte();
        byte micro = readBuffer.getByte();
        BinarySerialiser binarySerialiser = SELF;
        Objects.requireNonNull(binarySerialiser);
        HeaderInfo header = binarySerialiser.new HeaderInfo(producer, major, minor, micro);
        if (!header.isCompatible()) {
            String msg = String.format("byte buffer version incompatible: reveived '%s' vs. this '%s'", header.toString(), headerThis.toString());
            throw new IllegalStateException(msg);
        }
        return header;
    }

    public static FieldHeader getFieldHeader(FastByteBuffer readBuffer) {
        String fieldName = readBuffer.getString();
        byte dataTypeByte = readBuffer.getByte();
        DataType dataType = DataType.fromByte(dataTypeByte);
        if (dataType.equals((Object)DataType.END_MARKER)) {
            return null;
        }
        if (dataType.isScalar()) {
            BinarySerialiser binarySerialiser = SELF;
            Objects.requireNonNull(binarySerialiser);
            return binarySerialiser.new FieldHeader(fieldName, dataType, new int[]{1});
        }
        int arrayDims = readBuffer.getInt();
        int[] dims = new int[arrayDims];
        for (int i = 0; i < arrayDims; ++i) {
            dims[i] = readBuffer.getInt();
        }
        BinarySerialiser binarySerialiser = SELF;
        Objects.requireNonNull(binarySerialiser);
        return binarySerialiser.new FieldHeader(fieldName, dataType, dims);
    }

    public static boolean getBoolean(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getBoolean();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static byte getByte(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getByte();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static short getShort(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getShort();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static int getInteger(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getInt();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static long getLong(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getLong();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static float getFloat(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getFloat();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static double getDouble(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getDouble();
        }
        throw new IndexOutOfBoundsException(READ_POSITION_AT_BUFFER_END);
    }

    public static String getString(FastByteBuffer readBuffer) {
        if (readBuffer.verifySize()) {
            return readBuffer.getString();
        }
        return null;
    }

    public static int[] getArrayDimensions(FastByteBuffer readBuffer) {
        int arrayDims = readBuffer.getInt();
        int[] dims = new int[arrayDims];
        for (int i = 0; i < arrayDims; ++i) {
            dims[i] = readBuffer.getInt();
        }
        return dims;
    }

    public static boolean[] getBooleanArray(FastByteBuffer readBuffer) {
        return readBuffer.getBooleanArray();
    }

    public static byte[] getByteArray(FastByteBuffer readBuffer) {
        return readBuffer.getByteArray();
    }

    public static short[] getShortArray(FastByteBuffer readBuffer) {
        return readBuffer.getShortArray();
    }

    public static int[] getIntArray(FastByteBuffer readBuffer) {
        return readBuffer.getIntArray();
    }

    public static long[] getLongArray(FastByteBuffer readBuffer) {
        return readBuffer.getLongArray();
    }

    public static float[] getFloatArray(FastByteBuffer readBuffer) {
        return readBuffer.getFloatArray();
    }

    public static double[] getDoubleArray(FastByteBuffer readBuffer) {
        return readBuffer.getDoubleArray();
    }

    public static String[] getStringArray(FastByteBuffer readBuffer) {
        return readBuffer.getStringArray();
    }

    protected static Object[] getGenericArrayAsPrimitive(FastByteBuffer readBuffer, DataType dataType) {
        Object[] retVal;
        switch (dataType) {
            case BOOL: {
                retVal = GenericsHelper.toObject(readBuffer.getBooleanArray());
                break;
            }
            case BYTE: {
                retVal = GenericsHelper.toObject(readBuffer.getByteArray());
                break;
            }
            case SHORT: {
                retVal = GenericsHelper.toObject(readBuffer.getShortArray());
                break;
            }
            case INT: {
                retVal = GenericsHelper.toObject(readBuffer.getIntArray());
                break;
            }
            case LONG: {
                retVal = GenericsHelper.toObject(readBuffer.getLongArray());
                break;
            }
            case FLOAT: {
                retVal = GenericsHelper.toObject(readBuffer.getFloatArray());
                break;
            }
            case DOUBLE: {
                retVal = GenericsHelper.toObject(readBuffer.getDoubleArray());
                break;
            }
            case STRING: {
                retVal = readBuffer.getStringArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + dataType);
            }
        }
        return retVal;
    }

    public static <K, V> Map<K, V> getMap(FastByteBuffer readBuffer, Map<K, V> map) {
        DataType keyDataType = DataType.fromByte(readBuffer.getByte());
        DataType valueDataType = DataType.fromByte(readBuffer.getByte());
        Object[] keys = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, keyDataType);
        Object[] values = BinarySerialiser.getGenericArrayAsPrimitive(readBuffer, valueDataType);
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    static {
        BinarySerialiser binarySerialiser = SELF = new BinarySerialiser();
        Objects.requireNonNull(binarySerialiser);
        headerThis = binarySerialiser.new HeaderInfo(BinarySerialiser.class.getSimpleName(), 1, 0, 0);
    }

    public class HeaderInfo {
        private final String producerName;
        private final byte versionMajor;
        private final byte versionMinor;
        private final byte versionMicro;

        private HeaderInfo(String producer, byte major, byte minor, byte micro) {
            this.producerName = producer;
            this.versionMajor = major;
            this.versionMinor = minor;
            this.versionMicro = micro;
        }

        public String getProducerName() {
            return this.producerName;
        }

        public byte getVersionMajor() {
            return this.versionMajor;
        }

        public byte getVersionMinor() {
            return this.versionMinor;
        }

        public byte getVersionMicro() {
            return this.versionMicro;
        }

        public boolean isCompatible() {
            return this.getVersionMajor() <= 1;
        }

        public String toString() {
            return String.format("%s-v%d.%d.%d", this.getProducerName(), this.getVersionMajor(), this.getVersionMinor(), this.getVersionMicro());
        }
    }

    public class FieldHeader {
        private final String fieldName;
        private final DataType dataType;
        private final int[] dimensions;

        private FieldHeader(String fieldName, DataType dataType, int[] dims) {
            this.fieldName = fieldName;
            this.dataType = dataType;
            this.dimensions = dims;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public int getDataDimension() {
            return this.dimensions.length;
        }

        public int[] getDataDimensions() {
            return this.dimensions;
        }

        public String toString() {
            if (this.dimensions.length == 1 && this.dimensions[0] == 1) {
                return String.format("[fieldName=%s, fieldType=%s]", this.fieldName, this.dataType.getAsString());
            }
            StringBuilder builder = new StringBuilder(27);
            builder.append("[fieldName=").append(this.fieldName).append(", fieldType=").append(this.dataType.getAsString()).append('[');
            for (int i = 0; i < this.dimensions.length; ++i) {
                builder.append(this.dimensions[i]);
                if (i > this.dimensions.length - 1) continue;
                builder.append(',');
            }
            builder.append("]]");
            return builder.toString();
        }
    }
}

