/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
EditableDataSet {
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;
    protected DoubleArrayList yErrorsPos;
    protected DoubleArrayList yErrorsNeg;

    public DoubleErrorDataSet(String name) {
        this(name, 0);
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleArrayList(initalSize);
        this.yValues = new DoubleArrayList(initalSize);
        this.yErrorsPos = new DoubleArrayList(initalSize);
        this.yErrorsNeg = new DoubleArrayList(initalSize);
        this.setErrorType(DataSetError.ErrorType.Y_ASYMMETRIC);
    }

    public DoubleErrorDataSet(DataSet another) {
        super(another.getName());
        this.set(another);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int initalSize, boolean deepCopy) {
        super(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        int errorMin = Math.min(Math.min(yErrorsPos.length, yErrorsNeg.length), initalSize);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, dataMaxIndex);
        if (deepCopy) {
            int size = Math.min(dataMaxIndex, initalSize);
            this.xValues = new DoubleArrayList(initalSize);
            this.yValues = new DoubleArrayList(initalSize);
            this.yErrorsPos = new DoubleArrayList(initalSize);
            this.yErrorsNeg = new DoubleArrayList(initalSize);
            this.resize(initalSize);
            System.arraycopy(xValues, 0, this.xValues.elements(), 0, size);
            System.arraycopy(yValues, 0, this.yValues.elements(), 0, size);
            System.arraycopy(yErrorsPos, 0, this.yErrorsPos.elements(), 0, size);
            System.arraycopy(yErrorsNeg, 0, this.yErrorsNeg.elements(), 0, size);
        } else {
            this.xValues = DoubleArrayList.wrap((double[])xValues);
            this.yValues = DoubleArrayList.wrap((double[])yValues);
            this.yErrorsPos = DoubleArrayList.wrap((double[])yErrorsPos);
            this.yErrorsNeg = DoubleArrayList.wrap((double[])yErrorsNeg);
        }
    }

    @Override
    public double[] getXValues() {
        return this.xValues.elements();
    }

    @Override
    public double[] getYValues() {
        return this.yValues.elements();
    }

    @Override
    public double[] getYErrorsPositive() {
        return this.yErrorsPos.elements();
    }

    @Override
    public double[] getYErrorsNegative() {
        return this.yErrorsNeg.elements();
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    public DoubleErrorDataSet clearData() {
        this.lock();
        this.xValues.clear();
        this.yValues.clear();
        this.yErrorsPos.clear();
        this.yErrorsNeg.clear();
        this.dataLabels.clear();
        this.dataStyles.clear();
        this.clearMetaInfo();
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    public DoubleErrorDataSet increaseCapacity(int amount) {
        this.lock();
        int size = this.getDataCount();
        boolean auto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.resize(this.getCapacity() + amount);
        this.resize(size);
        this.setAutoNotifaction(auto);
        return (DoubleErrorDataSet)this.unlock();
    }

    public DoubleErrorDataSet resize(int size) {
        this.lock();
        this.xValues.size(size);
        this.yValues.size(size);
        this.yErrorsPos.size(size);
        this.yErrorsNeg.size(size);
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public DoubleErrorDataSet trim() {
        this.lock();
        this.xValues.trim(0);
        this.yValues.trim(0);
        this.yErrorsPos.trim(0);
        this.yErrorsNeg.trim(0);
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    @Override
    public double getX(int index) {
        return this.xValues.elements()[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues.elements()[index];
    }

    @Override
    public double getXErrorNegative(int index) {
        return 0.0;
    }

    @Override
    public double getXErrorPositive(int index) {
        return 0.0;
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.yErrorsNeg.elements()[index];
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.yErrorsPos.elements()[index];
    }

    public DoubleErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock();
        this.xValues.add(x);
        this.yValues.add(y);
        this.yErrorsNeg.add(yErrorNeg);
        this.yErrorsPos.add(yErrorPos);
        if (label != null && !label.isEmpty()) {
            this.addDataLabel(this.xValues.size() - 1, label);
        }
        this.xRange.add(x);
        this.yRange.add(y - yErrorNeg);
        this.yRange.add(y + yErrorPos);
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public DoubleErrorDataSet add(double[] xValuesNew, double[] yValuesNew, double[] yErrorsNegNew, double[] yErrorsPosNew) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        this.xValues.addElements(this.xValues.size(), xValuesNew);
        this.yValues.addElements(this.yValues.size(), yValuesNew);
        this.yErrorsNeg.addElements(this.yErrorsNeg.size(), yErrorsNegNew);
        this.yErrorsPos.addElements(this.yErrorsPos.size(), yErrorsPosNew);
        this.xRange.add(xValuesNew);
        this.yRange.add(yValuesNew);
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet add(int index, double x, double y) {
        return this.add(index, x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(index, x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock();
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.add(indexAt, x);
        this.yValues.add(indexAt, y);
        this.yErrorsNeg.add(indexAt, yErrorNeg);
        this.yErrorsPos.add(indexAt, yErrorPos);
        this.dataLabels.addValueAndShiftKeys(indexAt, this.xValues.size(), label);
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        this.xRange.add(x);
        this.yRange.add(y - yErrorNeg);
        this.yRange.add(y + yErrorPos);
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleErrorDataSet add(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        this.lock();
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        AssertUtils.notNull("X coordinates", yErrorNeg);
        AssertUtils.notNull("Y coordinates", yErrorPos);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalDoubleArrays(x, y, min);
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.addElements(indexAt, x, 0, min);
        this.yValues.addElements(indexAt, y, 0, min);
        this.yErrorsNeg.addElements(indexAt, yErrorNeg, 0, min);
        this.yErrorsPos.addElements(indexAt, yErrorPos, 0, min);
        this.xRange.add(x, min);
        this.yRange.add(y, min);
        this.dataLabels.shiftKeys(indexAt, this.xValues.size());
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.xValues.removeElements(fromIndex, toIndex);
        this.yValues.removeElements(fromIndex, toIndex);
        this.yErrorsNeg.removeElements(fromIndex, toIndex);
        this.yErrorsPos.removeElements(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        try {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = x;
            this.yValues.elements()[index] = y;
            this.yErrorsNeg.elements()[index] = yErrorNeg;
            this.yErrorsPos.elements()[index] = yErrorPos;
            this.dataLabels.remove(index);
            this.dataStyles.remove(index);
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.setAutoNotifaction(oldAuto);
            this.unlock();
        }
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleErrorDataSet set(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        this.lock();
        try {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            System.arraycopy(yErrorNeg, 0, this.yErrorsNeg.elements(), index, yErrorNeg.length);
            System.arraycopy(yErrorPos, 0, this.yErrorsPos.elements(), index, yErrorPos.length);
            this.dataLabels.remove(index, index + x.length);
            this.dataStyles.remove(index, index + x.length);
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.unlock();
        }
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, dataMaxIndex);
        this.dataLabels.clear();
        this.dataStyles.clear();
        if (copy) {
            this.resize(0);
            this.xValues.addElements(0, xValues);
            this.yValues.addElements(0, yValues);
            this.yErrorsNeg.addElements(0, yErrorsNeg);
            this.yErrorsPos.addElements(0, yErrorsPos);
        } else {
            this.xValues = DoubleArrayList.wrap((double[])xValues);
            this.yValues = DoubleArrayList.wrap((double[])yValues);
            this.yErrorsNeg = DoubleArrayList.wrap((double[])yErrorsNeg);
            this.yErrorsPos = DoubleArrayList.wrap((double[])yErrorsPos);
        }
        this.computeLimits();
        return (DoubleErrorDataSet)((DoubleErrorDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(DataSet other) {
        int index;
        this.lock();
        other.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.dataLabels.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String label = other.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            this.addDataLabel(index, label);
        }
        this.dataStyles.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String style = other.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            this.addDataStyle(index, style);
        }
        this.setStyle(other.getStyle());
        if (other instanceof DataSetError) {
            this.set(other.getXValues(), other.getYValues(), ((DataSetError)other).getYErrorsNegative(), ((DataSetError)other).getYErrorsPositive(), true);
        } else {
            int count = other.getDataCount();
            this.set(other.getXValues(), other.getYValues(), new double[count], new double[count], true);
        }
        this.setAutoNotifaction(oldAuto);
        other.unlock();
        return (DoubleErrorDataSet)this.unlock();
    }
}

