/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ClassFieldDescriptionIterator<E extends ClassFieldDescription>
implements Iterator<ClassFieldDescription> {
    public static int maxRecursionLevel = 10;
    private final List<ClassFieldDescription> list = new LinkedList<ClassFieldDescription>();
    private final Iterator<ClassFieldDescription> iterator;

    public ClassFieldDescriptionIterator(ClassFieldDescription fieldObj) {
        this.parse(fieldObj, 0);
        this.iterator = this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ClassFieldDescription next() {
        return this.iterator.next();
    }

    private void parse(ClassFieldDescription fieldObj, int recursionLevel) {
        if (recursionLevel > maxRecursionLevel) {
            throw new IllegalStateException("recursion error while scanning object structure: recursionLevel = '" + recursionLevel + "' > " + ClassFieldDescriptionIterator.class.getSimpleName() + ".maxRecursionLevel ='" + maxRecursionLevel + "'");
        }
        this.list.add(fieldObj);
        for (ClassFieldDescription child : fieldObj.getChildren()) {
            this.parse(child, recursionLevel + 1);
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

