/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.ClassDescriptions;
import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import de.gsi.dataset.serializer.spi.FieldHeader;
import de.gsi.dataset.serializer.spi.FieldSerialiser;
import de.gsi.dataset.serializer.spi.iobuffer.FieldBoxedValueArrayHelper;
import de.gsi.dataset.serializer.spi.iobuffer.FieldBoxedValueHelper;
import de.gsi.dataset.serializer.spi.iobuffer.FieldDataSetHelper;
import de.gsi.dataset.serializer.spi.iobuffer.FieldPrimitiveValueHelper;
import de.gsi.dataset.serializer.spi.iobuffer.FieldPrimitveValueArrayHelper;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoBufferSerialiser
extends AbstractSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoBufferSerialiser.class);
    private final IoBuffer ioBuffer;

    public IoBufferSerialiser(IoBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        this.ioBuffer = buffer;
        this.startMarkerFunction = subClassName -> BinarySerialiser.putStartMarker(this.ioBuffer, subClassName);
        this.endMarkerFunction = subClassName -> BinarySerialiser.putEndMarker(this.ioBuffer, subClassName);
        FieldPrimitiveValueHelper.register(this, this.ioBuffer);
        FieldPrimitveValueArrayHelper.register(this, this.ioBuffer);
        FieldBoxedValueHelper.register(this, this.ioBuffer);
        FieldBoxedValueArrayHelper.register(this, this.ioBuffer);
        FieldSerialiser.FieldSerialiserFunction collectionReader = (obj, field) -> {
            Collection origCollection = (Collection)field.getField().get(obj);
            origCollection.clear();
            Collection setVal = BinarySerialiser.getCollection(this.ioBuffer, origCollection);
            field.getField().set(obj, setVal);
        };
        FieldSerialiser.FieldSerialiserFunction collectionWriter = (obj, field) -> {
            Collection retVal = (Collection)field.getField().get(obj);
            BinarySerialiser.put(this.ioBuffer, field.getFieldName(), retVal);
        };
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, collectionReader, collectionWriter, Collection.class, new Class[0]));
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, collectionReader, collectionWriter, List.class, new Class[0]));
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, collectionReader, collectionWriter, Queue.class, new Class[0]));
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, collectionReader, collectionWriter, Set.class, new Class[0]));
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, (obj, field) -> field.getField().set(obj, BinarySerialiser.getEnum(this.ioBuffer, (Enum)field.getField().get(obj))), (obj, field) -> BinarySerialiser.put(this.ioBuffer, field.getFieldName(), (Enum)field.getField().get(obj)), Enum.class, new Class[0]));
        this.addClassDefinition(new IoBufferFieldSerialiser(this.ioBuffer, (obj, field) -> {
            Map origMap = (Map)field.getField().get(obj);
            origMap.clear();
            Map setVal = BinarySerialiser.getMap(this.ioBuffer, origMap);
            field.getField().set(obj, setVal);
        }, (obj, field) -> {
            Map retVal = (Map)field.getField().get(obj);
            BinarySerialiser.put(this.ioBuffer, field.getFieldName(), retVal);
        }, Map.class, new Class[0]));
        FieldDataSetHelper.register(this, this.ioBuffer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)AbstractSerialiser.class.getName()).addArgument((Object)this.knownClasses().size()).log("{} added {} known classes");
        }
    }

    protected void deserialise(Object obj, FieldHeader fieldRoot, ClassFieldDescription classFieldDescription, int recursionDepth) throws IllegalAccessException {
        String ioName = fieldRoot.getFieldName();
        ClassFieldDescription firstMatchingField = null;
        for (ClassFieldDescription field : classFieldDescription) {
            if (!field.getFieldName().equals(ioName)) continue;
            firstMatchingField = field;
            break;
        }
        if (firstMatchingField == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument((Object)ioName).log("did not find matching field: '{}'");
            }
            for (FieldHeader fieldHeader : fieldRoot.getChildren()) {
                String fieldName = fieldHeader.getFieldName();
                Optional<ClassFieldDescription> subFieldDescription = classFieldDescription.getChildren().stream().filter(e -> e.getFieldName().equals(fieldName)).findFirst();
                if (!subFieldDescription.isPresent()) continue;
                this.deserialise(obj, fieldHeader, subFieldDescription.get(), recursionDepth + 1);
            }
            return;
        }
        Class<?> fieldClass = firstMatchingField.getType();
        if (firstMatchingField.isFinal() && !fieldClass.isInterface()) {
            LOGGER.atWarn().addArgument((Object)firstMatchingField.getFieldNameRelative()).log("cannot set final field '{}'");
            return;
        }
        Optional<FieldSerialiser> serialiser = this.findFieldSerialiserForKnownClassOrInterface(fieldClass, firstMatchingField.getActualTypeArguments());
        if (serialiser.isEmpty()) {
            for (FieldHeader fieldHeader : fieldRoot.getChildren()) {
                String fieldName = fieldHeader.getFieldName();
                Optional<ClassFieldDescription> subFieldDescription = classFieldDescription.getChildren().stream().filter(e -> e.getFieldName().equals(fieldName)).findFirst();
                if (!subFieldDescription.isPresent()) continue;
                this.deserialise(obj, fieldHeader, subFieldDescription.get(), recursionDepth + 1);
            }
            return;
        }
        this.ioBuffer.position(fieldRoot.getDataBufferPosition());
        if (serialiser.isPresent()) {
            serialiser.get().getReaderFunction().exec(firstMatchingField.getMemberClassObject(obj), firstMatchingField);
            return;
        }
        throw new IllegalStateException("should not happen -- cannot serialise field - " + firstMatchingField.getFieldNameRelative() + " - class type = " + firstMatchingField.getTypeName());
    }

    @Override
    public Object deserialiseObject(Object obj) throws IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null (yet)");
        }
        BinarySerialiser.HeaderInfo bufferHeader = BinarySerialiser.checkHeaderInfo(this.ioBuffer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)bufferHeader).log("read header = {}");
        }
        ClassFieldDescription classFieldDescription = ClassDescriptions.get(obj.getClass(), new Class[0]);
        FieldHeader fieldRoot = BinarySerialiser.parseIoStream(this.ioBuffer);
        this.deserialise(obj, fieldRoot, classFieldDescription, 0);
        return obj;
    }

    public IoBuffer getBuffer() {
        return this.ioBuffer;
    }

    @Override
    public void serialiseObject(Object obj) throws IllegalAccessException {
        BinarySerialiser.putHeaderInfo(this.ioBuffer);
        super.serialiseObject(obj);
        BinarySerialiser.putEndMarker(this.ioBuffer, "OBJ_ROOT_END");
    }
}

