/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.spi.AbstractDataSet;

public abstract class AbstractErrorDataSet<D extends AbstractErrorDataSet<D>>
extends AbstractDataSet<D>
implements DataSetError {
    private static final long serialVersionUID = -5592816592868472957L;
    private DataSetError.ErrorType[] errorType;

    protected AbstractErrorDataSet(String name, int dimension, DataSetError.ErrorType ... errorTypes) {
        super(name, dimension);
        this.errorType = errorTypes;
    }

    @Override
    public D fireInvalidated(UpdateEvent event) {
        super.fireInvalidated(event);
        return (D)this.getThis();
    }

    @Override
    public DataSetError.ErrorType getErrorType(int dimIndex) {
        return this.errorType[dimIndex];
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public DataSetLock<D> lock() {
        return super.lock();
    }

    @Override
    public D recomputeLimits(int dimension) {
        if (dimension == 1) {
            return (D)this.getThis();
        }
        this.lock().writeLockGuard(() -> {
            block4: for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                this.getAxisDescription(dimIndex).clear();
                int dataCount = this.getDataCount(dimIndex);
                switch (this.getErrorType(dimIndex)) {
                    case NO_ERROR: {
                        super.recomputeLimits(dimIndex);
                        continue block4;
                    }
                    case ASYMMETRIC: {
                        double value;
                        int i;
                        for (i = 0; i < dataCount; ++i) {
                            value = this.get(dimIndex, i);
                            double errorNeg = this.getErrorNegative(dimIndex, i);
                            double errorPos = this.getErrorPositive(dimIndex, i);
                            this.getAxisDescription(dimIndex).add(value - errorNeg);
                            this.getAxisDescription(dimIndex).add(value + errorPos);
                        }
                        continue block4;
                    }
                    default: {
                        double value;
                        int i;
                        for (i = 0; i < dataCount; ++i) {
                            value = this.get(dimIndex, i);
                            double error = this.getErrorPositive(dimIndex, i);
                            this.getAxisDescription(dimIndex).add(value - error);
                            this.getAxisDescription(dimIndex).add(value + error);
                        }
                    }
                }
            }
        });
        return (D)this.getThis();
    }

    public D setErrorType(int dimIndex, DataSetError.ErrorType errorType) {
        this.errorType[dimIndex] = errorType;
        return (D)this.getThis();
    }
}

