/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.spi.utils.Tuple;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public class ListDataSet
extends AbstractDataSet<ListDataSet>
implements DataSet2D {
    private static final long serialVersionUID = -4444745436188783390L;
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected List<DoublePoint> data = new ArrayList<DoublePoint>();

    public ListDataSet(String name) {
        super(name, 2);
    }

    public ListDataSet(String name, double[] yValues) {
        this(name);
        AssertUtils.notNull("Y data", yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePoint(Double.valueOf(i), yValues[i]));
        }
    }

    public ListDataSet(String name, double[] xValues, double[] yValues) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePoint(xValues[i], yValues[i]));
        }
    }

    public ListDataSet(String name, List<DoublePoint> values) {
        this(name);
        AssertUtils.notNull("values", values);
        this.data.clear();
        this.data.addAll(values);
    }

    public ListDataSet add(double x, double y) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DoublePoint(x, y));
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (ListDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public ListDataSet add(double[] xValues, double[] yValues) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.getAxisDescription(0).setMax(Double.NaN);
            this.getAxisDescription(1).setMax(Double.NaN);
            for (int i = 0; i < xValues.length; ++i) {
                this.data.add(new DoublePoint(xValues[i], yValues[i]));
                this.getAxisDescription(0).add(xValues[i]);
                this.getAxisDescription(1).add(yValues[i]);
            }
        });
        return (ListDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public String addDataLabel(int index, String label) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.put(index, label));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    @Override
    public String addDataStyle(int index, String style) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.put(index, style));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public ListDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (ListDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getX() : this.data.get(index).getY();
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    public ListDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            this.data.subList(fromIndex, toIndex).clear();
            this.getAxisDescription(0).setMax(Double.NaN);
            this.getAxisDescription(1).setMax(Double.NaN);
        });
        return (ListDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public ListDataSet remove(int[] indices) {
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return this;
        }
        this.lock().writeLockGuard(() -> {
            ArrayList<Tuple> tupleTobeRemovedReferences = new ArrayList<Tuple>();
            for (int indexToRemove : indices) {
                tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
            }
            this.data.removeAll(tupleTobeRemovedReferences);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (ListDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public String removeDataLabel(int index) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String removeStyle(int index) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    public ListDataSet set(int index, double x, double y) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(index, this.getDataCount());
            this.data.get(index).set(x, y);
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (ListDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public ListDataSet set(List<DoublePoint> values) {
        AssertUtils.notNull("values", values);
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.data.addAll(values);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (ListDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }
}

