/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.testdata.spi.AbstractTestFunction;

public class GaussFunction
extends AbstractTestFunction<GaussFunction> {
    private static final long serialVersionUID = -2090964369869257806L;

    public GaussFunction(String name, int count) {
        super(name, count);
    }

    @Override
    public double[] generateY(int count) {
        double[] retVal = new double[count];
        double centre = 0.5 * (double)count;
        double sigma = (double)count / 10.0;
        for (int i = 0; i < count; ++i) {
            double x = i;
            retVal[i] = GaussFunction.gauss(x, centre, sigma) * sigma;
        }
        return retVal;
    }

    public static double gauss(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double gauss(double x, double mu, double sigma) {
        return GaussFunction.gauss((x - mu) / sigma) / sigma;
    }
}

