/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset;

import de.gsi.dataset.DataSet;

public interface DataSetError
extends DataSet {
    default public double getErrorNegative(int dimIndex, double x) {
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(dimIndex, index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount(0) - 1));
        double y2 = this.get(dimIndex, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return this.getErrorNegative(dimIndex, index1);
        }
        double de1 = this.getErrorNegative(dimIndex, index1);
        return de1 + (this.getErrorNegative(dimIndex, index2) - de1) * (x - x1) / (x2 - x1);
    }

    public double getErrorNegative(int var1, int var2);

    default public double getErrorPositive(int dimIndex, double x) {
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(dimIndex, index1);
        int index2 = x1 < x ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount(0) - 1));
        double y2 = this.get(dimIndex, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return this.getErrorPositive(dimIndex, index1);
        }
        double de1 = this.getErrorPositive(dimIndex, index1);
        return de1 + (this.getErrorPositive(dimIndex, index2) - de1) * (x - x1) / (x2 - x1);
    }

    public double getErrorPositive(int var1, int var2);

    default public double[] getErrorsNegative(int dimIndex) {
        int n = this.getDataCount(dimIndex);
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getErrorNegative(dimIndex, i);
        }
        return retValues;
    }

    default public double[] getErrorsPositive(int dimIndex) {
        int n = this.getDataCount(dimIndex);
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.getErrorPositive(dimIndex, i);
        }
        return retValues;
    }

    public ErrorType getErrorType(int var1);

    public static enum ErrorType {
        NO_ERROR,
        SYMMETRIC,
        ASYMMETRIC;


        boolean isAssymmetric() {
            return this.equals((Object)ASYMMETRIC);
        }
    }
}

