/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultAxisDescription;

public abstract class AbstractDataSet3D<D extends AbstractDataSet3D<D>>
extends AbstractDataSet<D>
implements DataSet3D {
    private static final long serialVersionUID = 2766945109681463872L;

    public AbstractDataSet3D(String name) {
        super(name, 3);
        this.getAxisDescriptions().add(new DefaultAxisDescription((DataSet)this, "z-Axis", "a.u."));
    }

    @Override
    public int getDataCount() {
        return this.getDataCount(0) * this.getDataCount(1);
    }

    @Override
    public D recomputeLimits(int dimension) {
        this.lock().writeLockGuard(() -> {
            this.getAxisDescription(dimension).clear();
            if (dimension == 0) {
                int dataCount = this.getDataCount(0);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < dataCount; ++i) {
                    axisRange.add(this.getX(i));
                }
            } else if (dimension == 1) {
                int dataCount = this.getDataCount(1);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < dataCount; ++i) {
                    axisRange.add(this.getY(i));
                }
            } else {
                int xDataCount = this.getDataCount(0);
                int yDataCount = this.getDataCount(1);
                AxisDescription axisRange = this.getAxisDescription(dimension);
                for (int i = 0; i < xDataCount; ++i) {
                    for (int j = 0; j < yDataCount; ++j) {
                        axisRange.add(this.getZ(i, j));
                    }
                }
            }
        });
        return (D)((AbstractDataSet3D)this.getThis());
    }
}

