/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.AxisNameChangeEvent;
import de.gsi.dataset.event.AxisRangeChangeEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.spi.DataRange;
import de.gsi.dataset.spi.utils.MathUtils;

public class DefaultAxisDescription
extends DataRange
implements AxisDescription {
    private final DataSet dataSet;
    private String name;
    private String unit;

    public DefaultAxisDescription() {
        this.dataSet = null;
        this.name = "unknown axis";
        this.unit = "a.u.";
    }

    public DefaultAxisDescription(DataSet dataSet, AxisDescription axisDesc) {
        this.dataSet = dataSet;
        this.set(axisDesc.getName(), axisDesc.getUnit(), axisDesc.getMin(), axisDesc.getMax());
    }

    public DefaultAxisDescription(DataSet dataSet, String axisName, String ... axisUnit) {
        this.dataSet = dataSet;
        this.set(axisName, axisUnit);
    }

    public DefaultAxisDescription(DataSet dataSet, String axisName, String axisUnit, double rangeMin, double rangeMax) {
        this.dataSet = dataSet;
        this.set(axisName, axisUnit, rangeMin, rangeMax);
    }

    public DefaultAxisDescription(String axisName, String ... axisUnit) {
        this((DataSet)null, axisName, axisUnit);
    }

    @Override
    public boolean add(double value) {
        if (!super.add(value)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean add(double[] values, int nlength) {
        if (!super.add(values, nlength)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean clear() {
        return super.clear();
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, 1.0E-6);
    }

    public boolean equals(Object obj, double epsilon) {
        if (!(obj instanceof AxisDescription)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AxisDescription other = (AxisDescription)obj;
        if (this.hashCode() == other.hashCode()) {
            return true;
        }
        if (epsilon <= 0.0) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(other.getName())) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (this.getUnit() != null && !this.getUnit().equals(other.getUnit())) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (epsilon <= 0.0) {
            if (this.getMin() != other.getMin()) {
                return false;
            }
            if (this.getMax() != other.getMax()) {
                return false;
            }
        } else {
            if (!MathUtils.nearlyEqual(this.getMin(), other.getMin(), epsilon)) {
                return false;
            }
            if (!MathUtils.nearlyEqual(this.getMax(), other.getMax(), epsilon)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + Double.hashCode(this.getMin());
        result = 31 * result + Double.hashCode(this.getMax());
        return result;
    }

    private final void notifyFullChange() {
        if (this.dataSet == null || !this.dataSet.autoNotification().get()) {
            return;
        }
        this.dataSet.invokeListener(new AxisChangeEvent((EventSource)this.dataSet, "updated axis for '" + this.name + "' '[" + this.unit + "]'", -1));
    }

    private final void notifyNameChange() {
        if (this.dataSet == null || !this.dataSet.autoNotification().get()) {
            return;
        }
        this.dataSet.invokeListener(new AxisNameChangeEvent((EventSource)this.dataSet, "updated axis names for '" + this.name + "' '[" + this.unit + "]'", -1));
    }

    private final void notifyRangeChange() {
        if (this.dataSet == null || !this.dataSet.autoNotification().get()) {
            return;
        }
        this.dataSet.invokeListener(new AxisRangeChangeEvent((EventSource)this.dataSet, "updated axis range for '" + this.name + "' '[" + this.unit + "]'", -1));
    }

    @Override
    public boolean set(DataRange range) {
        if (!super.set(range)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean set(double min, double max) {
        if (super.set(min, max)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public final boolean set(String axisName, String ... axisUnit) {
        boolean namesHaveChanged = !DefaultAxisDescription.strEqual(this.name, axisName);
        this.name = axisName;
        if (axisUnit != null && axisUnit.length > 0 && !DefaultAxisDescription.strEqual(this.unit, axisUnit[0])) {
            this.unit = axisUnit[0];
            namesHaveChanged = true;
            if (axisUnit.length > 1) {
                throw new IllegalArgumentException("more than one unit is not allowed");
            }
        }
        if (namesHaveChanged) {
            this.notifyNameChange();
        }
        return false;
    }

    @Override
    public final boolean set(String axisName, String axisUnit, double rangeMin, double rangeMax) {
        boolean namesHaveChanged = !DefaultAxisDescription.strEqual(this.name, axisName) || !DefaultAxisDescription.strEqual(this.unit, axisUnit);
        this.name = axisName;
        this.unit = axisUnit;
        boolean rangeHasChanged = false;
        if (this.getMin() != rangeMin || this.getMax() != rangeMax) {
            rangeHasChanged = true;
            this.set(rangeMin, rangeMax);
        }
        if (namesHaveChanged && rangeHasChanged) {
            this.notifyFullChange();
        } else if (namesHaveChanged) {
            this.notifyNameChange();
        } else if (rangeHasChanged) {
            this.notifyRangeChange();
        }
        return true;
    }

    @Override
    public boolean setMax(double max) {
        if (!super.setMax(max)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public boolean setMin(double min) {
        if (!super.setMin(min)) {
            return false;
        }
        this.notifyRangeChange();
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ", axisName = '" + this.getName() + "', axisUnit = '" + this.getUnit() + "'";
    }

    private static boolean strEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }
}

