/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet,
DataSet2D {
    private static final long serialVersionUID = -493232313124620828L;
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;

    public DoubleDataSet(DataSet another) {
        super(another.getName(), another.getDimension());
        this.set(another);
    }

    public DoubleDataSet(String name) {
        this(name, 0);
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues, int initalSize, boolean deepCopy) {
        super(name, 2);
        this.set(xValues, yValues, initalSize, deepCopy);
    }

    public DoubleDataSet(String name, int initalSize) {
        super(name, 2);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleArrayList(initalSize);
        this.yValues = new DoubleArrayList(initalSize);
    }

    public DoubleDataSet add(double x, double y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public DoubleDataSet add(double x, double y, String label) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(x);
            this.yValues.add(y);
            if (label != null && !label.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, label);
            }
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public DoubleDataSet add(double[] xValuesNew, double[] yValuesNew) {
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        this.lock().writeLockGuard(() -> {
            int addAt = this.xValues.size();
            int newElements = Math.min(xValuesNew.length, yValuesNew.length);
            this.resize(addAt + newElements);
            this.xValues.setElements(addAt, xValuesNew);
            this.yValues.setElements(addAt, yValuesNew);
            this.getAxisDescription(0).add(xValuesNew);
            this.getAxisDescription(1).add(yValuesNew);
        });
        return (DoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleDataSet add(int index, double ... newValue) {
        return this.add(index, newValue[0], newValue[1], null);
    }

    public DoubleDataSet add(int index, double x, double y) {
        return this.add(index, x, y, null);
    }

    public DoubleDataSet add(int index, double x, double y, String label) {
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.add(indexAt, x);
            this.yValues.add(indexAt, y);
            this.getDataLabelMap().addValueAndShiftKeys(indexAt, this.xValues.size(), label);
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (DoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleDataSet add(int index, double[] x, double[] y) {
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalDoubleArrays(x, y, min);
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.addElements(indexAt, x, 0, min);
            this.yValues.addElements(indexAt, y, 0, min);
            this.getAxisDescription(0).add(x, min);
            this.getAxisDescription(0).add(y, min);
            this.getDataLabelMap().shiftKeys(indexAt, this.xValues.size());
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
        });
        return (DoubleDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues.elements()[index] : this.yValues.elements()[index];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount(int dimIndex) {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    @Override
    public final double[] getValues(int dimIndex) {
        return dimIndex == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    public DoubleDataSet increaseCapacity(int amount) {
        this.lock().writeLockGuard(() -> {
            int size = this.getDataCount();
            this.resize(this.getCapacity() + amount);
            this.resize(size);
        });
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            int clampedToIndex = Math.min(toIndex, this.getDataCount());
            this.xValues.removeElements(fromIndex, clampedToIndex);
            this.yValues.removeElements(fromIndex, clampedToIndex);
            this.getDataLabelMap().remove(fromIndex, clampedToIndex);
            this.getDataStyleMap().remove(fromIndex, clampedToIndex);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public DoubleDataSet resize(int size) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(size);
            this.yValues.size(size);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public DoubleDataSet set(DataSet other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            this.set(other.getValues(0), other.getValues(1), other.getDataCount(), true);
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                this.getAxisDescription(dimIndex).set(other.getAxisDescription(dimIndex));
            }
        }));
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, boolean copy) {
        return this.set(xValues, yValues, -1, true);
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, int nSamples, boolean copy) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        int dataMaxIndex = Math.min(xValues.length, yValues.length);
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        if (nSamples >= 0) {
            AssertUtils.indexInBounds(nSamples, xValues.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(nSamples, yValues.length + 1, "yValues bounds");
        }
        int nSamplesToAdd = nSamples >= 0 ? Math.min(nSamples, xValues.length) : xValues.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                if (this.xValues == null) {
                    this.xValues = new DoubleArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new DoubleArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, xValues, 0, nSamplesToAdd);
                this.yValues.addElements(0, yValues, 0, nSamplesToAdd);
            } else {
                this.xValues = DoubleArrayList.wrap((double[])xValues, (int)nSamplesToAdd);
                this.yValues = DoubleArrayList.wrap((double[])yValues, (int)nSamplesToAdd);
            }
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public DoubleDataSet set(int index, double ... newValue) {
        return this.set(index, newValue[0], newValue[1]);
    }

    public DoubleDataSet set(int index, double x, double y) {
        this.lock().writeLockGuard(() -> {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = x;
            this.yValues.elements()[index] = y;
            this.getDataLabelMap().remove(index);
            this.getDataStyleMap().remove(index);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    public DoubleDataSet set(int index, double[] x, double[] y) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            this.getDataLabelMap().remove(index, index + x.length);
            this.getDataStyleMap().remove(index, index + x.length);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public DoubleDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
        });
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }
}

