/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.floats.FloatArrayList;

public class FloatDataSet
extends AbstractDataSet<FloatDataSet>
implements EditableDataSet,
DataSet2D {
    private static final long serialVersionUID = 7625465583757088697L;
    protected FloatArrayList xValues;
    protected FloatArrayList yValues;

    public FloatDataSet(DataSet2D another) {
        super(another.getName(), another.getDimension());
        this.set(another);
    }

    public FloatDataSet(String name) {
        this(name, 0);
    }

    public FloatDataSet(String name, float[] xValues, float[] yValues, int initalSize, boolean deepCopy) {
        this(name);
        this.set(xValues, yValues, initalSize, deepCopy);
    }

    public FloatDataSet(String name, int initalSize) {
        super(name, 2);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new FloatArrayList(initalSize);
        this.yValues = new FloatArrayList(initalSize);
    }

    public FloatDataSet add(float x, float y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public FloatDataSet add(float x, float y, String label) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(x);
            this.yValues.add(y);
            if (label != null && !label.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, label);
            }
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (FloatDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet add(float[] xValuesNew, float[] yValuesNew) {
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalFloatArrays(xValuesNew, yValuesNew);
        this.lock().writeLockGuard(() -> {
            int i;
            this.xValues.addElements(this.xValues.size(), xValuesNew);
            this.yValues.addElements(this.yValues.size(), yValuesNew);
            for (i = 0; i < xValuesNew.length; ++i) {
                this.getAxisDescription(0).add(xValuesNew[i]);
            }
            for (i = 0; i < yValuesNew.length; ++i) {
                this.getAxisDescription(1).add(yValuesNew[i]);
            }
        });
        return (FloatDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public FloatDataSet add(int index, double ... newValue) {
        return this.add(index, (float)newValue[0], (float)newValue[1], null);
    }

    public FloatDataSet add(int index, double x, double y) {
        return this.add(index, (float)x, (float)y, null);
    }

    public FloatDataSet add(int index, float x, float y, String label) {
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.add(indexAt, x);
            this.yValues.add(indexAt, y);
            this.getDataLabelMap().addValueAndShiftKeys(indexAt, this.xValues.size(), label);
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
        });
        return (FloatDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet add(int index, float[] x, float[] y) {
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalFloatArrays(x, y, min);
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.addElements(indexAt, x, 0, min);
            this.yValues.addElements(indexAt, y, 0, min);
            for (int i = 0; i < min; ++i) {
                this.getAxisDescription(0).add(x[i]);
                this.getAxisDescription(1).add(y[i]);
            }
            this.getDataLabelMap().shiftKeys(indexAt, this.xValues.size());
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
        });
        return (FloatDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (FloatDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public double get(int dimIndex, int index) {
        return dimIndex == 0 ? (double)this.xValues.elements()[index] : (double)this.yValues.elements()[index];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount(int dimIndex) {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    public float[] getXFloatValues() {
        return this.xValues.elements();
    }

    @Override
    public double[] getXValues() {
        return FloatDataSet.toDoubles(this.xValues.elements());
    }

    public float[] getYFloatValues() {
        return this.yValues.elements();
    }

    @Override
    public double[] getYValues() {
        return FloatDataSet.toDoubles(this.yValues.elements());
    }

    public FloatDataSet increaseCapacity(int amount) {
        this.lock().writeLockGuard(() -> {
            int size = this.getDataCount();
            this.resize(this.getCapacity() + amount);
            this.resize(size);
        });
        return (FloatDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public FloatDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            int clampedToIndex = Math.min(toIndex, this.getDataCount());
            this.xValues.removeElements(fromIndex, clampedToIndex);
            this.yValues.removeElements(fromIndex, clampedToIndex);
            this.getDataLabelMap().remove(fromIndex, clampedToIndex);
            this.getDataLabelMap().remove(fromIndex, clampedToIndex);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (FloatDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public FloatDataSet resize(int size) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(size);
            this.yValues.size(size);
        });
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public FloatDataSet set(DataSet2D other) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            int index;
            this.set(FloatDataSet.toFloats(other.getXValues()), FloatDataSet.toFloats(other.getYValues()), other.getDataCount(), true);
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(other.getStyle());
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                this.getAxisDescription(dimIndex).set(other.getAxisDescription(dimIndex));
            }
        }));
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public FloatDataSet set(float[] xValues, float[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public FloatDataSet set(float[] xValues, float[] yValues, boolean copy) {
        return this.set(xValues, yValues, -1, true);
    }

    public FloatDataSet set(float[] xValues, float[] yValues, int nSamples, boolean copy) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalFloatArrays(xValues, yValues);
        if (nSamples >= 0) {
            AssertUtils.indexInBounds(nSamples, xValues.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(nSamples, yValues.length + 1, "yValues bounds");
        }
        int nSamplesToAdd = nSamples >= 0 ? Math.min(nSamples, xValues.length) : xValues.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                if (this.xValues == null) {
                    this.xValues = new FloatArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new FloatArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, xValues, 0, nSamplesToAdd);
                this.yValues.addElements(0, yValues, 0, nSamplesToAdd);
            } else {
                this.xValues = FloatArrayList.wrap((float[])xValues, (int)nSamplesToAdd);
                this.yValues = FloatArrayList.wrap((float[])yValues, (int)nSamplesToAdd);
            }
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public FloatDataSet set(int index, double ... newValue) {
        return this.set(index, newValue[0], newValue[1]);
    }

    public FloatDataSet set(int index, double x, double y) {
        this.lock().writeLockGuard(() -> {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = (float)x;
            this.yValues.elements()[index] = (float)y;
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public FloatDataSet set(int index, double[] x, double[] y) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(FloatDataSet.toFloats(x), 0, this.xValues.elements(), index, x.length);
            System.arraycopy(FloatDataSet.toFloats(y), 0, this.yValues.elements(), index, y.length);
            this.getDataLabelMap().remove(index, index + x.length);
            this.getDataStyleMap().remove(index, index + x.length);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public FloatDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
        });
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public static double[] toDoubles(float[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }

    public static float[] toFloats(double[] input) {
        float[] floatArray = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floatArray[i] = (float)input[i];
        }
        return floatArray;
    }
}

