/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.Histogram2D;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram2
extends AbstractHistogram
implements Histogram2D,
DataSet3D {
    private static final long serialVersionUID = -5583974934398282519L;
    protected final Histogram xProjection;
    protected final Histogram yProjection;

    public Histogram2(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY) {
        super(name, nBinsX, minX, maxX, nBinsY, minY, maxY);
        this.xProjection = new Histogram(name + "-Proj-X", nBinsX, minX, maxX, true);
        this.yProjection = new Histogram(name + "-Proj-Y", nBinsY, minY, maxY, false);
    }

    @Override
    public int fill(double x, double y) {
        return this.fill(x, y, 1.0);
    }

    @Override
    public int fill(double x, double y, double w) {
        int ret = this.lock().writeLockGuard(() -> {
            this.xProjection.fill(x, w);
            this.yProjection.fill(y, w);
            int bin = super.findBin(x, y);
            super.addBinContent(bin, w);
            return bin;
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "fill()"));
        return ret;
    }

    @Override
    public int findFirstBinAbove(double x, double y) {
        return this.findBin(x, y);
    }

    @Override
    public double get(int dimIndex, int binIndex) {
        return this.getBinCenter(dimIndex, binIndex + 1);
    }

    @Override
    public int getDataCount() {
        return this.getDataCount(0);
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }

    @Override
    public int getIndex(int dimIndex, double value) {
        return this.findBin(dimIndex, value);
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    public Histogram1D getProjectionX() {
        return this.xProjection;
    }

    public Histogram1D getProjectionY() {
        return this.yProjection;
    }

    protected double getSum(int dimIndex, int bin) {
        double sum = 0.0;
        if (dimIndex == 0) {
            for (int i = 0; i < this.getDataCount(dimIndex); ++i) {
                sum += this.getZ(i - 1, bin - 1);
            }
        } else {
            for (int i = 0; i < this.getDataCount(1); ++i) {
                sum += this.getZ(bin - 1, i - 1);
            }
        }
        return sum;
    }

    @Override
    public double getValue(int dimIndex, double x) {
        return 0.0;
    }

    @Override
    public List<String> getWarningList() {
        String[] axisPrefix = new String[]{"-x", "-y", "-z"};
        LinkedList<String> retVal = new LinkedList<String>(super.getWarningList());
        for (int dim = 0; dim < this.getDimension(); ++dim) {
            Object axisName;
            Object object = axisName = dim < axisPrefix.length ? axisPrefix[dim] : "-dim" + (dim + 1);
            if (this.getSum(dim, 0) > 0.0) {
                retVal.add("under-range" + (String)axisName);
            }
            if (!(this.getSum(dim, this.getDataCount() - 1) > 0.0)) continue;
            retVal.add("over-range" + (String)axisName);
        }
        return retVal;
    }

    @Override
    public double getZ(int xIndex, int yIndex) {
        int bin = (yIndex + 1) * this.getDataCount() + xIndex + 1;
        return super.getBinContent(bin);
    }

    @Override
    public void reset() {
        this.xProjection.reset();
        this.yProjection.reset();
        super.reset();
    }
}

