/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.trees;

import de.gsi.dataset.utils.trees.AbstractMap;
import de.gsi.dataset.utils.trees.AbstractSet;
import de.gsi.dataset.utils.trees.IndexedNavigableMap;
import de.gsi.dataset.utils.trees.IndexedTreeSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class IndexedTreeMap<K, V>
extends AbstractMap<K, V>
implements IndexedNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;
    private final Comparator<? super K> comparator;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet = null;
    private transient KeySet<K> navigableKeySet = null;
    private transient NavigableMap<K, V> descendingMap = null;

    public IndexedTreeMap() {
        this.comparator = null;
    }

    public IndexedTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public IndexedTreeMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.putAll(m);
    }

    public IndexedTreeMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    public void addAllForTreeSet(SortedSet<? extends K> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    private final Entry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry<K, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<Object, V> middle = new Entry<Object, V>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry<K, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private void buildFromSorted(int size, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, IndexedTreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return IndexedTreeMap.exportEntry(this.getCeilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        return IndexedTreeMap.keyOrNull(this.getCeilingEntry(key));
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        IndexedTreeMap clone = null;
        try {
            clone = (IndexedTreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.navigableKeySet = null;
        clone.descendingMap = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public final int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (IndexedTreeMap.valEquals(value, e.value)) {
                return true;
            }
            e = IndexedTreeMap.successor(e);
        }
        return false;
    }

    public void dbg() {
        Entry<K, V> e = this.getFirstEntry();
        while (e != null) {
            String l = e.left == null ? "null" : "   " + e.left.key;
            String r = e.right == null ? "null" : "   " + e.right.key;
            System.out.println(e.key + ":" + l + ":" + r + ":" + e.weight);
            e = IndexedTreeMap.successor(e);
        }
    }

    public void debug() throws Exception {
        Entry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (e.weight != e.sumup()) {
                throw new IllegalStateException("Weight is incorrect:" + e.weight + "!=" + e.sumup() + " for " + e.key);
            }
            e = IndexedTreeMap.successor(e);
        }
    }

    private void deleteEntry(Entry<K, V> noteToDelete) {
        Entry replacement;
        Entry<K, V> p = noteToDelete;
        ++this.modCount;
        --this.size;
        if (p.left != null && p.right != null) {
            Entry<K, V> s = IndexedTreeMap.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                int delta = IndexedTreeMap.getWeight(replacement) - IndexedTreeMap.getWeight(p.parent.left);
                p.parent.left = replacement;
                p.parent.updateWeight(delta);
            } else {
                int delta = IndexedTreeMap.getWeight(replacement) - IndexedTreeMap.getWeight(p.parent.right);
                p.parent.right = replacement;
                p.parent.updateWeight(delta);
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent.updateWeight(-1);
                p.parent = null;
            }
        }
    }

    public Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public Entry<K, V> exactEntry(int index) {
        return this.getExactEntry(this.root, index);
    }

    @Override
    public K exactKey(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getExactKey(this.root, index);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return IndexedTreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public K firstKey() {
        return IndexedTreeMap.key(this.getFirstEntry());
    }

    private void fixAfterDeletion(Entry<K, V> x) {
        while (x != this.root && IndexedTreeMap.colorOf(x)) {
            Entry<K, V> sib;
            if (x == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(x))) {
                sib = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(x));
                if (!IndexedTreeMap.colorOf(sib)) {
                    IndexedTreeMap.setColor(sib, true);
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), false);
                    this.rotateLeft(IndexedTreeMap.parentOf(x));
                    sib = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(x));
                }
                if (IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(sib)) && IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(sib))) {
                    IndexedTreeMap.setColor(sib, false);
                    x = IndexedTreeMap.parentOf(x);
                    continue;
                }
                if (IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(sib))) {
                    IndexedTreeMap.setColor(IndexedTreeMap.leftOf(sib), true);
                    IndexedTreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(x));
                }
                IndexedTreeMap.setColor(sib, IndexedTreeMap.colorOf(IndexedTreeMap.parentOf(x)));
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
                IndexedTreeMap.setColor(IndexedTreeMap.rightOf(sib), true);
                this.rotateLeft(IndexedTreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(x));
            if (!IndexedTreeMap.colorOf(sib)) {
                IndexedTreeMap.setColor(sib, true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), false);
                this.rotateRight(IndexedTreeMap.parentOf(x));
                sib = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(x));
            }
            if (IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(sib)) && IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(sib))) {
                IndexedTreeMap.setColor(sib, false);
                x = IndexedTreeMap.parentOf(x);
                continue;
            }
            if (IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(sib))) {
                IndexedTreeMap.setColor(IndexedTreeMap.rightOf(sib), true);
                IndexedTreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(x));
            }
            IndexedTreeMap.setColor(sib, IndexedTreeMap.colorOf(IndexedTreeMap.parentOf(x)));
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
            IndexedTreeMap.setColor(IndexedTreeMap.leftOf(sib), true);
            this.rotateRight(IndexedTreeMap.parentOf(x));
            x = this.root;
        }
        IndexedTreeMap.setColor(x, true);
    }

    private void fixAfterInsertion(Entry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry<K, V> y;
            if (IndexedTreeMap.parentOf(x) == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)))) {
                y = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)));
                if (!IndexedTreeMap.colorOf(y)) {
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
                    IndexedTreeMap.setColor(y, true);
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)), false);
                    x = IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x));
                    continue;
                }
                if (x == IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(x))) {
                    x = IndexedTreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)), false);
                this.rotateRight(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)));
                continue;
            }
            y = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)));
            if (!IndexedTreeMap.colorOf(y)) {
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
                IndexedTreeMap.setColor(y, true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)), false);
                x = IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x));
                continue;
            }
            if (x == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(x))) {
                x = IndexedTreeMap.parentOf(x);
                this.rotateRight(x);
            }
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(x), true);
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)), false);
            this.rotateLeft(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return IndexedTreeMap.exportEntry(this.getFloorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return IndexedTreeMap.keyOrNull(this.getFloorEntry(key));
    }

    @Override
    public V get(Object key) {
        Entry<Object, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    public final Entry<K, V> getCeilingEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                Entry parent = p.parent;
                Entry<K, V> ch = p;
                while (parent != null && ch == parent.right) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    public final Entry<K, V> getEntry(K key) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(key);
        }
        if (key == null) {
            throw new IllegalStateException("key is null");
        }
        Comparable k = (Comparable)key;
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = k.compareTo(p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    public final Entry<K, V> getEntryUsingComparator(K key) {
        K k = key;
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            Entry<K, V> p = this.root;
            while (p != null) {
                int cmp = cpr.compare(k, p.key);
                if (cmp < 0) {
                    p = p.left;
                    continue;
                }
                if (cmp > 0) {
                    p = p.right;
                    continue;
                }
                return p;
            }
        }
        return null;
    }

    private Entry<K, V> getExactEntry(Entry<K, V> e, int index) {
        if (e.left == null && index == 0) {
            return e;
        }
        if (e.left == null && e.right == null) {
            return e;
        }
        if (e.left != null && e.left.weight > index) {
            return this.getExactEntry(e.left, index);
        }
        if (e.left != null && e.left.weight == index) {
            return e;
        }
        return this.getExactEntry(e.right, index - (e.left == null ? 0 : e.left.weight) - 1);
    }

    private K getExactKey(Entry<K, V> e, int index) {
        if (e.left == null && index == 0) {
            return e.key;
        }
        if (e.left == null && e.right == null) {
            return e.key;
        }
        if (e.left != null && e.left.weight > index) {
            return this.getExactKey(e.left, index);
        }
        if (e.left != null && e.left.weight == index) {
            return e.key;
        }
        return this.getExactKey(e.right, index - (e.left == null ? 0 : e.left.weight) - 1);
    }

    public final Entry<K, V> getFirstEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    public final Entry<K, V> getFloorEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                Entry parent = p.parent;
                Entry<K, V> ch = p;
                while (parent != null && ch == parent.left) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    public final Entry<K, V> getHigherEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right != null) {
                p = p.right;
                continue;
            }
            Entry parent = p.parent;
            Entry<K, V> ch = p;
            while (parent != null && ch == parent.right) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    public final Entry<K, V> getLastEntry() {
        Entry<K, V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    public final Entry<K, V> getLowerEntry(K key) {
        Entry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left != null) {
                p = p.left;
                continue;
            }
            Entry parent = p.parent;
            Entry<K, V> ch = p;
            while (parent != null && ch == parent.left) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, null, true, false, toKey, inclusive);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return IndexedTreeMap.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return IndexedTreeMap.keyOrNull(this.getHigherEntry(key));
    }

    @Override
    public int keyIndex(K key) {
        if (key == null) {
            throw new IllegalStateException("key should be non-null");
        }
        Entry<K, V> e = this.getEntry(key);
        if (e == null) {
            throw new IllegalStateException("element is null for key = " + key);
        }
        if (e == this.root) {
            return IndexedTreeMap.getWeight(e) - IndexedTreeMap.getWeight(e.right) - 1;
        }
        int index = 0;
        index += IndexedTreeMap.getWeight(e.left);
        Entry p = e.parent;
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            while (p != null) {
                int cmp = cpr.compare(key, p.key);
                if (cmp > 0) {
                    index += IndexedTreeMap.getWeight(p.left) + 1;
                }
                p = p.parent;
            }
        } else {
            Comparable k = (Comparable)key;
            while (p != null) {
                if (k.compareTo(p.key) > 0) {
                    index += IndexedTreeMap.getWeight(p.left) + 1;
                }
                p = p.parent;
            }
        }
        return index;
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return IndexedTreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public K lastKey() {
        return IndexedTreeMap.key(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return IndexedTreeMap.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return IndexedTreeMap.keyOrNull(this.getLowerEntry(key));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> p = this.getFirstEntry();
        Map.Entry<K, V> result = IndexedTreeMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> p = this.getLastEntry();
        Map.Entry<K, V> result = IndexedTreeMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        int cmp;
        Entry<K, V> parent;
        Entry<K, V> t = this.root;
        if (t == null) {
            this.root = new Entry<K, V>(key, value, null);
            this.root.weight = 1;
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            do {
                parent = t;
                cmp = cpr.compare(key, t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        } else {
            if (key == null) {
                throw new IllegalStateException("key is null");
            }
            Comparable k = (Comparable)key;
            do {
                parent = t;
                cmp = k.compareTo(t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        }
        Entry<K, V> e = new Entry<K, V>(key, value, parent);
        if (cmp < 0) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        e.updateWeight(1);
        this.fixAfterInsertion(e);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    public void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
        if (this.root != null) {
            this.updateWeight(this.root);
        }
    }

    @Override
    public V remove(Object key) {
        Entry<Object, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    private void rotateLeft(Entry<K, V> p) {
        if (p != null) {
            Entry r = p.right;
            int delta = IndexedTreeMap.getWeight(r.left) - IndexedTreeMap.getWeight(p.right);
            p.right = r.left;
            p.updateWeight(delta);
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                delta = IndexedTreeMap.getWeight(r) - IndexedTreeMap.getWeight(p.parent.left);
                p.parent.left = r;
                p.parent.updateWeight(delta);
            } else {
                delta = IndexedTreeMap.getWeight(r) - IndexedTreeMap.getWeight(p.parent.right);
                p.parent.right = r;
                p.parent.updateWeight(delta);
            }
            delta = IndexedTreeMap.getWeight(p) - IndexedTreeMap.getWeight(r.left);
            r.left = p;
            r.updateWeight(delta);
            p.parent = r;
        }
    }

    private void rotateRight(Entry<K, V> p) {
        if (p != null) {
            Entry l = p.left;
            int delta = IndexedTreeMap.getWeight(l.right) - IndexedTreeMap.getWeight(p.left);
            p.left = l.right;
            p.updateWeight(delta);
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                delta = IndexedTreeMap.getWeight(l) - IndexedTreeMap.getWeight(p.parent.right);
                p.parent.right = l;
                p.parent.updateWeight(delta);
            } else {
                delta = IndexedTreeMap.getWeight(l) - IndexedTreeMap.getWeight(p.parent.left);
                p.parent.left = l;
                p.parent.updateWeight(delta);
            }
            delta = IndexedTreeMap.getWeight(p) - IndexedTreeMap.getWeight(l.right);
            l.right = p;
            l.updateWeight(delta);
            p.parent = l;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey, inclusive, true, null, true);
    }

    private int updateWeight(Entry<K, V> e) {
        int weight = 1;
        if (e.left != null) {
            weight += this.updateWeight(e.left);
        }
        if (e.right != null) {
            weight += this.updateWeight(e.right);
        }
        e.weight = weight;
        return weight;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private static <K, V> boolean colorOf(Entry<K, V> p) {
        return p == null ? true : p.color;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    public static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> e) {
        return e == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(e);
    }

    private static <K, V> int getWeight(Entry<K, V> p) {
        return p == null ? 0 : p.weight;
    }

    public static <K> K key(Entry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public static <K, V> K keyOrNull(Entry<K, V> e) {
        return e == null ? null : (K)e.key;
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> p) {
        return p == null ? null : p.parent;
    }

    public static <K, V> Entry<K, V> predecessor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            Entry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<K, V> ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> p) {
        return p == null ? null : p.right;
    }

    private static <K, V> void setColor(Entry<K, V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    public static <K, V> Entry<K, V> successor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<K, V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    public static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public void clear() {
            IndexedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return IndexedTreeMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(IndexedTreeMap.this.getFirstEntry());
        }

        @Override
        public boolean remove(Object o) {
            Entry e = IndexedTreeMap.this.getFirstEntry();
            while (e != null) {
                if (IndexedTreeMap.valEquals(e.getValue(), o)) {
                    IndexedTreeMap.this.deleteEntry(e);
                    return true;
                }
                e = IndexedTreeMap.successor(e);
            }
            return false;
        }

        @Override
        public int size() {
            return IndexedTreeMap.this.size();
        }
    }

    protected final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    protected abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        protected Entry<K, V> next;
        protected Entry<K, V> lastReturned;
        protected int expectedModCount;

        protected PrivateEntryIterator(Entry<K, V> first) {
            this.expectedModCount = IndexedTreeMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        public final Entry<K, V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IndexedTreeMap.successor(e);
            this.lastReturned = e;
            return e;
        }

        public final Entry<K, V> prevEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IndexedTreeMap.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            IndexedTreeMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = IndexedTreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends java.util.AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 2043167872700380033L;
        protected final IndexedTreeMap<K, V> m;
        protected final K lo;
        protected final K hi;
        protected final boolean fromStart;
        protected final boolean toEnd;
        protected final boolean loInclusive;
        protected final boolean hiInclusive;
        protected transient NavigableMap<K, V> descendingMapView = null;
        protected transient EntrySetView entrySetView = null;
        protected transient KeySet<K> navigableKeySetView = null;

        protected NavigableSubMap(IndexedTreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            if (m == null) {
                throw new IllegalStateException("m must not be null");
            }
            if (!fromStart && !toEnd && m.compare(lo, hi) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        public final Entry<K, V> absCeiling(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getCeilingEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        public final Entry<K, V> absFloor(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getFloorEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        public final Entry<K, V> absHigher(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            Entry<K, V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        public final Entry<K, V> absHighest() {
            Entry<K, V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.key) ? null : e;
        }

        public final Entry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        public final Entry<K, V> absLower(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            Entry<K, V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        public final Entry<K, V> absLowest() {
            Entry<K, V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        public final Entry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K key) {
            return IndexedTreeMap.exportEntry(this.subCeiling(key));
        }

        @Override
        public final K ceilingKey(K key) {
            return IndexedTreeMap.keyOrNull(this.subCeiling(key));
        }

        @Override
        public final boolean containsKey(Object key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        protected abstract Iterator<K> descendingKeyIterator();

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return IndexedTreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final K firstKey() {
            return IndexedTreeMap.key(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K key) {
            return IndexedTreeMap.exportEntry(this.subFloor(key));
        }

        @Override
        public final K floorKey(K key) {
            return IndexedTreeMap.keyOrNull(this.subFloor(key));
        }

        @Override
        public final V get(Object key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K key) {
            return IndexedTreeMap.exportEntry(this.subHigher(key));
        }

        @Override
        public final K higherKey(K key) {
            return IndexedTreeMap.keyOrNull(this.subHigher(key));
        }

        public final boolean inClosedRange(Object key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        public final boolean inRange(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        public final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        protected abstract Iterator<K> keyIterator();

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return IndexedTreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final K lastKey() {
            return IndexedTreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K key) {
            return IndexedTreeMap.exportEntry(this.subLower(key));
        }

        @Override
        public final K lowerKey(K key) {
            return IndexedTreeMap.keyOrNull(this.subLower(key));
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> e = this.subLowest();
            Map.Entry<K, V> result = IndexedTreeMap.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> e = this.subHighest();
            Map.Entry<K, V> result = IndexedTreeMap.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public final V remove(Object key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        protected abstract Entry<K, V> subCeiling(K var1);

        protected abstract Entry<K, V> subFloor(K var1);

        protected abstract Entry<K, V> subHigher(K var1);

        protected abstract Entry<K, V> subHighest();

        protected abstract Entry<K, V> subLower(K var1);

        protected abstract Entry<K, V> subLowest();

        @Override
        public final SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        public final boolean tooHigh(Object key) {
            int c;
            return !this.toEnd && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        public final boolean tooLow(Object key) {
            int c;
            return !this.fromStart && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        protected final class SubMapKeyIterator
        extends SubMapIterator<K> {
            protected SubMapKeyIterator(Entry<K, V> first, Entry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        protected abstract class SubMapIterator<T>
        implements Iterator<T> {
            protected Entry<K, V> lastReturned;
            protected Entry<K, V> next;
            protected final K fenceKey;
            protected int expectedModCount;

            protected SubMapIterator(Entry<K, V> first, Entry<K, V> fence) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = first;
                this.fenceKey = fence == null ? null : fence.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            public final Entry<K, V> nextEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = IndexedTreeMap.successor(e);
                this.lastReturned = e;
                return e;
            }

            public final Entry<K, V> prevEntry() {
                Entry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = IndexedTreeMap.predecessor(e);
                this.lastReturned = e;
                return e;
            }

            public final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            public final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        protected final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(Entry<K, V> first, Entry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        protected abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            protected EntrySetView() {
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                return node != null && IndexedTreeMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean isEmpty() {
                Entry n = NavigableSubMap.this.absLowest();
                return n == null || NavigableSubMap.this.tooHigh(n.key);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = NavigableSubMap.this.m.getEntry(key);
                if (node != null && IndexedTreeMap.valEquals(node.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }
        }

        protected final class DescendingSubMapKeyIterator
        extends SubMapIterator<K> {
            DescendingSubMapKeyIterator(Entry<K, V> last, Entry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        protected final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(Entry<K, V> last, Entry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> map) {
            this.m = map;
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof IndexedTreeMap) {
                return ((IndexedTreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new IndexedTreeSet<E>(this.m.descendingMap());
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new IndexedTreeSet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof IndexedTreeMap) {
                return ((IndexedTreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new IndexedTreeSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new IndexedTreeSet<E>(this.m.tailMap(fromElement, inclusive));
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            IndexedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = IndexedTreeMap.this.getEntry(entry.getKey());
            return p != null && IndexedTreeMap.valEquals(p.getValue(), value);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(IndexedTreeMap.this.getFirstEntry());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = IndexedTreeMap.this.getEntry(entry.getKey());
            if (p != null && IndexedTreeMap.valEquals(p.getValue(), value)) {
                IndexedTreeMap.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return IndexedTreeMap.this.size();
        }
    }

    protected final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        protected EntryIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    protected static final class Entry<K, V>
    implements Map.Entry<K, V> {
        protected K key;
        protected V value;
        protected Entry<K, V> left = null;
        protected Entry<K, V> right = null;
        protected Entry<K, V> parent;
        protected boolean color = true;
        protected int weight = 0;

        protected Entry(K key, V value, Entry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return IndexedTreeMap.valEquals(this.key, e.getKey()) && IndexedTreeMap.valEquals(this.value, e.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public int sumup() {
            int left = this.left == null ? 0 : this.left.sumup();
            int right = this.right == null ? 0 : this.right.sumup();
            return left + right + 1;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public void updateWeight(int delta) {
            this.weight += delta;
            Entry<K, V> p = this.parent;
            while (p != null) {
                p.weight += delta;
                p = p.parent;
            }
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(IndexedTreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new DescendingEntrySetView();
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Entry<K, V> subCeiling(K key) {
            return this.absFloor(key);
        }

        @Override
        public Entry<K, V> subFloor(K key) {
            return this.absCeiling(key);
        }

        @Override
        public Entry<K, V> subHigher(K key) {
            return this.absLower(key);
        }

        @Override
        public Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        public Entry<K, V> subLower(K key) {
            return this.absHigher(key);
        }

        @Override
        public Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        protected final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            protected DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }
    }

    protected static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(IndexedTreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new AscendingEntrySetView();
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Entry<K, V> subCeiling(K key) {
            return this.absCeiling(key);
        }

        @Override
        public Entry<K, V> subFloor(K key) {
            return this.absFloor(key);
        }

        @Override
        public Entry<K, V> subHigher(K key) {
            return this.absHigher(key);
        }

        @Override
        public Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        public Entry<K, V> subLower(K key) {
            return this.absLower(key);
        }

        @Override
        public Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        protected final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            protected AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }
}

