/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.trees;

import de.gsi.dataset.utils.trees.IndexedNavigableMap;
import de.gsi.dataset.utils.trees.IndexedNavigableSet;
import de.gsi.dataset.utils.trees.IndexedTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;

public class IndexedTreeSet<E>
extends AbstractSet<E>
implements IndexedNavigableSet<E>,
Cloneable,
Serializable {
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;
    private transient NavigableMap<E, Object> m;

    public IndexedTreeSet() {
        this(new IndexedTreeMap());
    }

    public IndexedTreeSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public IndexedTreeSet(Comparator<? super E> comparator) {
        this(new IndexedTreeMap(comparator));
    }

    IndexedTreeSet(NavigableMap<E, Object> m) {
        if (!(m instanceof IndexedTreeMap)) {
            throw new IllegalArgumentException("Map should implement IndexedTreeMap");
        }
        this.m = m;
    }

    public IndexedTreeSet(SortedSet<E> s) {
        this(s.comparator());
        this.addAll(s);
    }

    @Override
    public boolean add(E e) {
        return this.m.put(e, PRESENT) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.m.isEmpty() && !c.isEmpty() && c instanceof SortedSet && this.m instanceof IndexedTreeMap) {
            Comparator mc;
            SortedSet set = (SortedSet)c;
            IndexedTreeMap map = (IndexedTreeMap)this.m;
            Comparator cc = set.comparator();
            if (cc == (mc = map.comparator()) || cc != null && cc.equals(mc)) {
                map.addAllForTreeSet(set, PRESENT);
                return true;
            }
        }
        return super.addAll(c);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    public Object clone() {
        IndexedTreeSet clone = null;
        try {
            clone = (IndexedTreeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.m = new IndexedTreeMap<E, Object>(this.m);
        return clone;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    public void debug() throws Exception {
        IndexedTreeMap.Entry e = ((IndexedTreeMap)this.m).getFirstEntry();
        while (e != null) {
            if (e.weight != e.sumup()) {
                throw new IllegalStateException("Weight is incorrect:" + e.weight + "!=" + e.sumup() + " for " + e.key);
            }
            e = IndexedTreeMap.successor(e);
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new IndexedTreeSet<E>(this.m.descendingMap());
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E get(int index) {
        Map.Entry e = ((IndexedNavigableMap)this.m).exactEntry(index);
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public int getIndex(E e) {
        return ((IndexedNavigableMap)this.m).keyIndex(e);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new IndexedTreeSet<E>(this.m.headMap(toElement, inclusive));
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> e = this.m.pollFirstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> e = this.m.pollLastEntry();
        return e == null ? null : (E)e.getKey();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator c = (Comparator)s.readObject();
        IndexedTreeMap<Object, Object> tm = c == null ? new IndexedTreeMap<E, Object>() : new IndexedTreeMap(c);
        this.m = tm;
        int size = s.readInt();
        tm.readTreeSet(size, s, PRESENT);
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) == PRESENT;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new IndexedTreeSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new IndexedTreeSet<E>(this.m.tailMap(fromElement, inclusive));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.m.comparator());
        s.writeInt(this.m.size());
        for (Object e : this.m.keySet()) {
            s.writeObject(e);
        }
    }
}

