/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.event;

import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventThreadHelper;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.utils.AggregateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public interface EventSource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void addListener(EventListener listener) {
        List<EventListener> list = this.updateEventListener();
        synchronized (list) {
            Objects.requireNonNull(listener, "UpdateListener must not be null");
            if (!this.updateEventListener().contains(listener)) {
                this.updateEventListener().add(listener);
            }
        }
    }

    public AtomicBoolean autoNotification();

    default public void invokeListener() {
        this.invokeListener(null);
    }

    default public void invokeListener(UpdateEvent updateEvent) {
        this.invokeListener(updateEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void invokeListener(UpdateEvent updateEvent, boolean executeParallel) {
        ArrayList<EventListener> eventListener;
        if (this.updateEventListener() == null) {
            return;
        }
        List<EventListener> list = this.updateEventListener();
        synchronized (list) {
            AtomicBoolean atomicBoolean = this.autoNotification();
            synchronized (atomicBoolean) {
                if (!this.isAutoNotification() || this.updateEventListener().isEmpty()) {
                    return;
                }
            }
            eventListener = new ArrayList<EventListener>(this.updateEventListener());
        }
        if (!executeParallel) {
            AggregateException exceptions = new AggregateException(EventSource.class.getSimpleName() + "(NonParallel)");
            for (EventListener listener : eventListener) {
                try {
                    listener.handle(updateEvent);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                throw exceptions;
            }
            return;
        }
        UpdateEvent event = updateEvent == null ? new UpdateEvent(this) : updateEvent;
        AggregateException exceptions = new AggregateException(EventSource.class.getSimpleName() + "(Parallel)");
        ArrayList<Callable<Boolean>> workers = new ArrayList<Callable<Boolean>>();
        for (EventListener listener : eventListener) {
            workers.add(() -> {
                try {
                    listener.handle(event);
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    exceptions.add(e);
                    exceptions.fillInStackTrace();
                    return Boolean.FALSE;
                }
            });
        }
        try {
            ExecutorService es = EventThreadHelper.getExecutorService();
            ArrayList jobs = new ArrayList();
            for (Callable callable : workers) {
                jobs.add(es.submit(callable));
            }
            for (Future future : jobs) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            exceptions.add(new IllegalStateException("one parallel worker thread finished execution with error", e));
        }
        if (!exceptions.isEmpty()) {
            throw exceptions;
        }
    }

    default public boolean isAutoNotification() {
        return this.autoNotification().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void removeListener(EventListener listener) {
        List<EventListener> list = this.updateEventListener();
        synchronized (list) {
            Objects.requireNonNull(listener, "UpdateListener must not be null");
            this.updateEventListener().remove(listener);
        }
    }

    public List<EventListener> updateEventListener();
}

