/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer;

import de.gsi.dataset.serializer.Cat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public enum DataType {
    START_MARKER(0, "start_marker", "", 1L, Cat.SINGLE_VALUE, new Class[0]),
    BOOL(1, "bool", "boolean", 1L, Cat.SINGLE_VALUE, Boolean.TYPE, Boolean.class),
    BYTE(2, "byte", "byte", 1L, Cat.SINGLE_VALUE, Byte.TYPE, Byte.class),
    SHORT(3, "short", "short", 2L, Cat.SINGLE_VALUE, Short.TYPE, Short.class),
    INT(4, "int", "int", 4L, Cat.SINGLE_VALUE, Integer.TYPE, Integer.class),
    LONG(5, "long", "long", 8L, Cat.SINGLE_VALUE, Long.TYPE, Long.class),
    FLOAT(6, "float", "float", 4L, Cat.SINGLE_VALUE, Float.TYPE, Float.class),
    DOUBLE(7, "double", "double", 8L, Cat.SINGLE_VALUE, Double.TYPE, Double.class),
    CHAR(8, "char", "char", 2L, Cat.SINGLE_VALUE, Character.TYPE, Character.class),
    STRING(9, "string", "java.lang.String", 1L, Cat.SINGLE_VALUE, String.class),
    BOOL_ARRAY(101, "bool_array", "[Z", 1L, Cat.ARRAY, boolean[].class, Boolean[].class),
    BYTE_ARRAY(102, "byte_array", "[B", 1L, Cat.ARRAY, byte[].class, Byte[].class),
    SHORT_ARRAY(103, "short_array", "[S", 2L, Cat.ARRAY, short[].class, Short[].class),
    INT_ARRAY(104, "int_array", "[I", 4L, Cat.ARRAY, int[].class, Integer[].class),
    LONG_ARRAY(105, "long_array", "[J", 8L, Cat.ARRAY, long[].class, Long[].class),
    FLOAT_ARRAY(106, "float_array", "[F", 4L, Cat.ARRAY, float[].class, Float[].class),
    DOUBLE_ARRAY(107, "double_array", "[D", 8L, Cat.ARRAY, double[].class, Double[].class),
    CHAR_ARRAY(108, "char_array", "[C", 2L, Cat.ARRAY, char[].class, Character[].class),
    STRING_ARRAY(109, "string_array", "[java.lang.String", 1L, Cat.ARRAY, String[].class),
    COLLECTION(200, "collection", "", 1L, Cat.ARRAY, Collection.class),
    ENUM(201, "enum", "java.lang.Enum", 4L, Cat.ARRAY, Enum.class),
    LIST(202, "list", "", 1L, Cat.ARRAY, List.class),
    MAP(203, "map", "", 1L, Cat.ARRAY, Map.class),
    QUEUE(204, "queue", "", 1L, Cat.ARRAY, Queue.class),
    SET(205, "set", "", 1L, Cat.ARRAY, Set.class),
    OTHER(253, "other", "", 1L, Cat.COMPLEX_OBJECT, Object.class),
    END_MARKER(254, "end_marker", "", 1L, Cat.SINGLE_VALUE, new Class[0]);

    private final byte uniqueType;
    private final long primitiveSize;
    private final String stringValue;
    private final String javaName;
    private final List<Class<?>> classTypes;
    private final boolean scalar;
    private final boolean array;
    private final boolean object;

    private DataType(int uniqueType, String stringValue, String javaName, long primitiveSize, Cat type, Class<?> ... classType) {
        this.uniqueType = (byte)uniqueType;
        this.stringValue = stringValue;
        this.javaName = javaName;
        this.primitiveSize = primitiveSize;
        this.classTypes = Arrays.asList(classType);
        this.scalar = type.equals((Object)Cat.SINGLE_VALUE);
        this.array = type.equals((Object)Cat.ARRAY);
        this.object = type.equals((Object)Cat.COMPLEX_OBJECT);
    }

    public byte getAsByte() {
        return this.uniqueType;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public List<Class<?>> getClassTypes() {
        return this.classTypes;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public long getPrimitiveSize() {
        return this.primitiveSize;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isObject() {
        return this.object;
    }

    public boolean isScalar() {
        return this.scalar;
    }

    public static DataType fromByte(byte value) {
        for (DataType type : DataType.values()) {
            if (type.uniqueType != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Entry type '" + value + "' is not supported");
    }

    public static DataType fromClassType(Class<?> classType) {
        for (DataType type : DataType.values()) {
            if (!type.getClassTypes().contains(classType)) continue;
            return type;
        }
        throw new IllegalArgumentException("data type not implemented " + classType.getSimpleName());
    }

    public static DataType fromJavaTypeString(String str) {
        for (DataType type : DataType.values()) {
            if (!type.stringValue.equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("Entry type '" + str + "' is not supported");
    }

    public static DataType fromString(String str) {
        for (DataType type : DataType.values()) {
            if (!type.stringValue.equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("Entry type '" + str + "' is not supported");
    }
}

