/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.spi.ClassDescriptions;
import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import de.gsi.dataset.serializer.spi.FieldSerialiser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerialiser.class);
    private static final Map<String, Constructor<Object>> CLASS_CONSTRUCTOR_MAP = new ConcurrentHashMap<String, Constructor<Object>>();
    private final Map<Class<?>, List<FieldSerialiser>> classMap = new ConcurrentHashMap();
    protected Consumer<String> startMarkerFunction;
    protected Consumer<String> endMarkerFunction;

    public void addClassDefinition(FieldSerialiser serialiser) {
        if (serialiser == null) {
            throw new IllegalArgumentException("serialiser must not be null");
        }
        if (serialiser.getClassPrototype() == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        if (serialiser.getGenericsPrototypes() == null) {
            throw new IllegalArgumentException("types must not be null");
        }
        List list = this.knownClasses().computeIfAbsent(serialiser.getClassPrototype(), key -> new ArrayList());
        if (list.isEmpty() || !list.contains(serialiser)) {
            list.add(serialiser);
        }
    }

    protected boolean checkClassCompatibility(List<Class<?>> ref1, List<Class<?>> ref2) {
        if (ref1.size() != ref2.size()) {
            return false;
        }
        if (ref1.isEmpty() && ref2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < ref1.size(); ++i) {
            Class<?> class2;
            Class<?> class1 = ref1.get(i);
            if (class1.equals(class2 = ref2.get(i)) || class2.isAssignableFrom(class1)) continue;
            return false;
        }
        return true;
    }

    public void checkSerialiserAvailability(List<String> objList, ClassFieldDescription field) {
        boolean classIsKnown = this.isClassKnown(field.getType(), field.getActualTypeArguments());
        if (field.isSerializable() && !classIsKnown) {
            if (field.getChildren().isEmpty()) {
                String fieldType = field.getTypeName() + field.getGenericFieldTypeString();
                if (!objList.contains(fieldType)) {
                    objList.add(fieldType);
                }
            } else {
                field.getChildren().forEach(child -> this.checkSerialiserAvailability(objList, (ClassFieldDescription)child));
            }
        }
    }

    public abstract Object deserialiseObject(Object var1) throws IllegalAccessException;

    public Optional<FieldSerialiser> findFieldSerialiserForKnownClassOrInterface(Class<?> clazz, List<Class<?>> classGenericArguments) {
        List potentialMatchingKeys;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        List<FieldSerialiser> directClassMatchList = this.classMap.get(clazz);
        if (directClassMatchList != null && !directClassMatchList.isEmpty()) {
            if (directClassMatchList.size() == 1 || classGenericArguments == null || classGenericArguments.isEmpty()) {
                return Optional.of(directClassMatchList.get(0));
            }
            for (FieldSerialiser entry2 : directClassMatchList) {
                if (!this.checkClassCompatibility(classGenericArguments, entry2.getGenericsPrototypes())) continue;
                return Optional.of(entry2);
            }
        }
        if ((potentialMatchingKeys = this.knownClasses().keySet().stream().filter(k -> k.isAssignableFrom(clazz)).collect(Collectors.toList())) == null || potentialMatchingKeys.isEmpty()) {
            return Optional.empty();
        }
        List interfaceMatchList = potentialMatchingKeys.stream().map(key -> this.knownClasses().get(key)).flatMap(Collection::stream).collect(Collectors.toList());
        if (interfaceMatchList.size() == 1 || classGenericArguments == null || classGenericArguments.isEmpty()) {
            return Optional.of((FieldSerialiser)interfaceMatchList.get(0));
        }
        for (FieldSerialiser entry3 : interfaceMatchList) {
            if (!this.checkClassCompatibility(classGenericArguments, entry3.getGenericsPrototypes())) continue;
            return Optional.of(entry3);
        }
        return interfaceMatchList.stream().filter(entry -> entry.getGenericsPrototypes().isEmpty()).findFirst().map(Optional::of).orElse(Optional.empty());
    }

    public boolean isClassKnown(Class<?> clazz, List<Class<?>> classGenericArguments) {
        return this.findFieldSerialiserForKnownClassOrInterface(clazz, classGenericArguments).isPresent();
    }

    public Map<Class<?>, List<FieldSerialiser>> knownClasses() {
        return this.classMap;
    }

    public void serialiseObject(Object obj) throws IllegalAccessException {
        this.serialiseObject(obj, ClassDescriptions.get(obj.getClass(), new Class[0]), 0);
    }

    public void serialiseObject(Object rootObj, ClassFieldDescription root, int recursionDepth) throws IllegalAccessException {
        List<Class<?>> fieldGenericTypes;
        Class<?> fieldClass = root.getType();
        if (this.isClassKnown(fieldClass, fieldGenericTypes = root.getActualTypeArguments()) && recursionDepth != 0) {
            Optional<FieldSerialiser> serialiser = this.findFieldSerialiserForKnownClassOrInterface(fieldClass, root.getActualTypeArguments());
            if (serialiser.isEmpty()) {
                throw new IllegalStateException("should not happen -- cannot serialise field - " + root.getFieldNameRelative() + " - class type = " + root.getTypeName());
            }
            serialiser.get().getWriterFunction().exec(rootObj, root);
            return;
        }
        if (root.getChildren().isEmpty()) {
            return;
        }
        String subClass = root.getFieldName();
        if (recursionDepth != 0 && this.startMarkerFunction != null) {
            this.startMarkerFunction.accept(subClass);
        }
        Object newRoot = root.getField() == null ? rootObj : root.getField().get(rootObj);
        for (ClassFieldDescription field : root.getChildren()) {
            Object reference = field.getField().get(newRoot);
            if (reference == null) continue;
            this.serialiseObject(newRoot, field, recursionDepth + 1);
        }
        if (recursionDepth != 0 && this.endMarkerFunction != null) {
            this.endMarkerFunction.accept(subClass);
        }
    }

    public static int computeHashCode(Class<?> classPrototype, List<Class<?>> classGenericArguments) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (classPrototype == null ? 0 : classPrototype.getName().hashCode());
        if (classGenericArguments == null || classGenericArguments.isEmpty()) {
            return result;
        }
        for (Type type : classGenericArguments) {
            result = 31 * result + (type == null ? 0 : type.getTypeName().hashCode());
        }
        return result;
    }

    public static Constructor<Object> getClassConstructorByName(String name, Class<?> ... parameterTypes) {
        return CLASS_CONSTRUCTOR_MAP.computeIfAbsent(name, key -> {
            try {
                return ClassDescriptions.getClassByName(key).getDeclaredConstructor(parameterTypes);
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)Arrays.toString(parameterTypes)).addArgument((Object)name).log("exception while getting constructor{} for class {}");
                return null;
            }
        });
    }

    public static String[] getClassNames(List<Class<?>> classGenericArguments) {
        if (classGenericArguments == null) {
            return new String[0];
        }
        String[] argStrings = new String[classGenericArguments.size()];
        for (int i = 0; i < argStrings.length; ++i) {
            argStrings[i] = classGenericArguments.get(i).getName();
        }
        return argStrings;
    }

    public static String getGenericFieldSimpleTypeString(List<Class<?>> classArguments) {
        if (classArguments == null || classArguments.isEmpty()) {
            return "";
        }
        return classArguments.stream().map(Class::getSimpleName).collect(Collectors.joining(", ", "<", ">"));
    }
}

