/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.spi.ClassDescriptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFieldDescription {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFieldDescription.class);
    private static final int WILDCARD_EXTENDS_LENGTH = "? extends ".length();
    public static int maxRecursionLevel = 10;
    private String toStringName;
    private final int hierarchyDepth;
    private final Field field;
    private final String fieldName;
    private final String fieldNameRelative;
    private final Optional<ClassFieldDescription> parent;
    private final List<ClassFieldDescription> children = new ArrayList<ClassFieldDescription>();
    private final Map<String, ClassFieldDescription> hashMap = new ConcurrentHashMap<String, ClassFieldDescription>();
    private final Class<?> classType;
    private final DataType dataType;
    private final String typeName;
    private Type genericType;
    private List<Class<?>> genericTypeList;
    private List<String> genericTypeNameList;
    private String genericTypeNames;
    private final int modifierID;
    private String modifierStr;
    private final boolean modPublic;
    private final boolean modProtected;
    private final boolean modPrivate;
    private final boolean modAbstract;
    private final boolean modStatic;
    private final boolean modFinal;
    private final boolean modTransient;
    private final boolean modVolatile;
    private final boolean modSynchronized;
    private final boolean modNative;
    private final boolean modStrict;
    private final boolean modInterface;
    private final boolean isprimitive;
    private final boolean isclass;
    private final boolean isEnum;
    private final boolean serializable;
    private final AtomicInteger readCount = new AtomicInteger();
    private final AtomicInteger writeCount = new AtomicInteger();

    public ClassFieldDescription(Class<?> referenceClass, boolean fullScan) {
        this(referenceClass, null, null, 0);
        if (referenceClass == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        this.genericType = this.classType.getGenericSuperclass();
        ClassFieldDescription.exploreClass(this.classType, this, 0, fullScan);
    }

    protected ClassFieldDescription(Class<?> referenceClass, Field field, ClassFieldDescription parent, int recursionLevel) {
        this.hierarchyDepth = recursionLevel;
        Optional<Object> optional = this.parent = parent == null ? Optional.empty() : Optional.of(parent);
        if (referenceClass == null) {
            if (field == null) {
                throw new IllegalArgumentException("field must not be null");
            }
            this.field = field;
            this.classType = field.getType();
            this.fieldName = field.getName();
            if (this.parent.isPresent()) {
                String relativeName = this.parent.get().isRoot() ? "" : this.parent.get().getFieldNameRelative() + ".";
                this.fieldNameRelative = relativeName + this.fieldName;
            } else {
                this.fieldNameRelative = this.fieldName;
            }
            this.modifierID = field.getModifiers();
        } else {
            this.field = null;
            this.classType = referenceClass;
            this.fieldName = this.classType.getName();
            this.fieldNameRelative = "";
            this.modifierID = this.classType.getModifiers();
        }
        this.dataType = ClassFieldDescription.dataTypeFomClassType(this.classType);
        this.typeName = ClassDescriptions.translateClassName(this.classType.getTypeName());
        this.modPublic = Modifier.isPublic(this.modifierID);
        this.modProtected = Modifier.isProtected(this.modifierID);
        this.modPrivate = Modifier.isPrivate(this.modifierID);
        this.modAbstract = Modifier.isAbstract(this.modifierID);
        this.modStatic = Modifier.isStatic(this.modifierID);
        this.modFinal = Modifier.isFinal(this.modifierID);
        this.modTransient = Modifier.isTransient(this.modifierID);
        this.modVolatile = Modifier.isVolatile(this.modifierID);
        this.modSynchronized = Modifier.isSynchronized(this.modifierID);
        this.modNative = Modifier.isNative(this.modifierID);
        this.modStrict = Modifier.isStrict(this.modifierID);
        this.modInterface = this.classType.isInterface();
        this.isprimitive = this.classType.isPrimitive();
        this.isclass = !this.isprimitive && !this.modInterface;
        this.isEnum = Enum.class.isAssignableFrom(this.classType);
        this.serializable = !this.modTransient && !this.modStatic;
    }

    public ClassFieldDescription(Field field, ClassFieldDescription parent, int recursionLevel, boolean fullScan) {
        this(null, field, parent, recursionLevel);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (this.serializable) {
            field.setAccessible(true);
        }
        if (this.parent.isPresent() && (this.serializable || fullScan)) {
            this.parent.get().getChildren().add(this);
            this.parent.get().getFieldMap().put(this.fieldName, this);
        }
    }

    public Object allocateMemberClassField(Object fieldParent) throws IllegalAccessException {
        try {
            Object newFieldObj;
            Class<?> fieldParentClass = this.getParent(this, 1).getType();
            if (fieldParentClass.getDeclaringClass() == null) {
                Constructor<?> constr = fieldParentClass.getDeclaredConstructor(new Class[0]);
                newFieldObj = constr.newInstance(new Object[0]);
            } else {
                Constructor<?> constr = fieldParentClass.getDeclaredConstructor(fieldParent.getClass());
                newFieldObj = constr.newInstance(fieldParent);
            }
            this.getField().set(fieldParent, newFieldObj);
            return newFieldObj;
        }
        catch (InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.atError().setCause((Throwable)e).log("error initialising inner class object");
            return null;
        }
    }

    public List<String> getActualTypeArgumentNames() {
        if (this.genericTypeNameList == null) {
            this.genericTypeNameList = this.getActualTypeArguments().stream().map(t -> ClassDescriptions.translateClassName(t.getTypeName())).collect(Collectors.toList());
        }
        return this.genericTypeNameList;
    }

    public List<Class<?>> getActualTypeArguments() {
        if (this.genericTypeList == null) {
            Type[] typeArguments;
            this.genericTypeList = new ArrayList();
            if (this.field == null || this.getGenericType() == null || !(this.getGenericType() instanceof ParameterizedType)) {
                return this.genericTypeList;
            }
            for (Type type : typeArguments = ((ParameterizedType)this.getGenericType()).getActualTypeArguments()) {
                String tName = type.getTypeName();
                String tCleanName = tName.charAt(0) == '?' ? tName.substring(WILDCARD_EXTENDS_LENGTH) : tName;
                Class<?> clazz = ClassDescriptions.getClassByNameNonVerboseError(tCleanName);
                this.genericTypeList.add(clazz);
            }
        }
        return this.genericTypeList;
    }

    public List<ClassFieldDescription> getChildren() {
        return this.children;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Field getField() {
        return this.field;
    }

    public Map<String, ClassFieldDescription> getFieldMap() {
        return this.hashMap;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldNameRelative() {
        return this.fieldNameRelative;
    }

    public String getGenericFieldTypeString() {
        if (this.genericTypeNames == null) {
            this.genericTypeNames = this.getActualTypeArgumentNames().isEmpty() ? "" : this.getActualTypeArgumentNames().stream().collect(Collectors.joining(", ", "<", ">"));
        }
        return this.genericTypeNames;
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.field == null ? new Type(){

                @Override
                public String getTypeName() {
                    return "unknown type";
                }
            } : this.field.getGenericType();
        }
        return this.genericType;
    }

    public int getHierarchyDepth() {
        return this.hierarchyDepth;
    }

    @Deprecated
    public Object getMemberClassObject(Object rootObject) {
        if (rootObject == null) {
            throw new IllegalArgumentException("rootObject is null");
        }
        if (this.isRoot()) {
            return rootObject;
        }
        int depth = this.getHierarchyDepth() - 1;
        Object temp = rootObject;
        Object parent1 = rootObject;
        for (int i = 0; i < depth; ++i) {
            ClassFieldDescription localParent = this.getParent(this, depth - i);
            try {
                if (localParent.getField() == null) {
                    return rootObject;
                }
                temp = localParent.getField().get(parent1);
                if (temp != null) {
                    return null;
                }
                temp = localParent.allocateMemberClassField(parent1);
                temp = localParent.getField().get(parent1);
                if (temp == null) {
                    throw new IllegalStateException("could not allocate inner class object field = " + this.field.toString());
                }
                parent1 = temp;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.atError().setCause((Throwable)e).log("could not retrieve inner loop object for field '" + this.field.toString());
            }
        }
        return temp;
    }

    public int getModifierID() {
        return this.modifierID;
    }

    public String getModifierString() {
        if (this.modifierStr == null) {
            this.modifierStr = Modifier.toString(this.modifierID);
        }
        return this.modifierStr;
    }

    public Optional<ClassFieldDescription> getParent() {
        return this.parent;
    }

    public ClassFieldDescription getParent(ClassFieldDescription field, int hierarchyLevel) {
        if (field == null) {
            throw new IllegalArgumentException("field is null at hierarchyLevel = " + hierarchyLevel);
        }
        if (hierarchyLevel == 0 || field.getParent().isEmpty()) {
            return field;
        }
        Optional<ClassFieldDescription> localParent = field.getParent();
        return this.getParent(localParent.isPresent() ? localParent.get() : null, hierarchyLevel - 1);
    }

    public Class<?> getType() {
        return this.classType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isAbstract() {
        return this.modAbstract;
    }

    public boolean isClass() {
        return this.isclass;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isFinal() {
        return this.modFinal;
    }

    public boolean isInterface() {
        return this.modInterface;
    }

    public boolean isNative() {
        return this.modNative;
    }

    public boolean isPrimitive() {
        return this.isprimitive;
    }

    public boolean isPrivate() {
        return this.modPrivate;
    }

    public boolean isProtected() {
        return this.modProtected;
    }

    public boolean isPublic() {
        return this.modPublic;
    }

    public boolean isRoot() {
        return this.hierarchyDepth == 0;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isStatic() {
        return this.modStatic;
    }

    public boolean isStrict() {
        return this.modStrict;
    }

    public boolean isSynchronized() {
        return this.modSynchronized;
    }

    public boolean isTransient() {
        return this.modTransient;
    }

    public boolean isVolatile() {
        return this.modVolatile;
    }

    public AtomicInteger readCount() {
        return this.readCount;
    }

    public void reset() {
        this.resetReadCount();
        this.resetWriteCount();
    }

    public void resetReadCount() {
        this.readCount.set(0);
        this.getChildren().stream().forEach(ClassFieldDescription::resetReadCount);
    }

    public void resetWriteCount() {
        this.writeCount.set(0);
        this.getChildren().stream().forEach(ClassFieldDescription::resetWriteCount);
    }

    public String toString() {
        if (this.toStringName == null) {
            this.toStringName = ClassFieldDescription.class.getSimpleName() + " for: " + this.getModifierString() + " " + this.getTypeName() + " " + this.getFieldNameRelative() + " (hierarchyDepth = " + this.getHierarchyDepth() + ")";
        }
        return this.toStringName;
    }

    public AtomicInteger writeCount() {
        return this.writeCount;
    }

    protected static DataType dataTypeFomClassType(Class<?> classType) {
        for (DataType type : DataType.values()) {
            if (!type.getClassTypes().contains(classType)) continue;
            return type;
        }
        return DataType.OTHER;
    }

    protected static void exploreClass(Class<? extends Object> classType, ClassFieldDescription parent, int recursionLevel, boolean fullScan) {
        if (classType == null) {
            throw new IllegalArgumentException("classType must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (recursionLevel > maxRecursionLevel) {
            throw new IllegalStateException("recursion error while scanning object structure: recursionLevel = '" + recursionLevel + "' > " + ClassFieldDescription.class.getSimpleName() + ".maxRecursionLevel ='" + maxRecursionLevel + "'");
        }
        if (classType.getSuperclass() != null && !classType.getSuperclass().equals(Object.class) && !classType.getSuperclass().equals(Enum.class)) {
            ClassFieldDescription.exploreClass(classType.getSuperclass(), parent, recursionLevel + 1, fullScan);
        }
        for (Field pfield : classType.getDeclaredFields()) {
            boolean isClassAndNotObjectOrEnmum;
            Optional<ClassFieldDescription> localParent = parent.getParent();
            if (localParent.isPresent() && pfield.getType().equals(localParent.get().getType()) && recursionLevel >= maxRecursionLevel || pfield.getName().startsWith("this$")) continue;
            ClassFieldDescription field = new ClassFieldDescription(pfield, parent, recursionLevel + 1, fullScan);
            boolean bl = isClassAndNotObjectOrEnmum = field.isClass() && (!field.getType().equals(Object.class) || !field.getType().equals(Enum.class));
            if (!field.isSerializable() || !isClassAndNotObjectOrEnmum && !field.isInterface() || !field.getDataType().equals((Object)DataType.OTHER)) continue;
            ClassFieldDescription.exploreClass(field.getType(), field, recursionLevel + 1, fullScan);
        }
    }
}

