/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.utils.AssertUtils;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Unsafe;

public class FastByteBuffer
implements IoBuffer {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    public static final long SIZE_OF_BOOLEAN = 1L;
    public static final long SIZE_OF_BYTE = 1L;
    public static final long SIZE_OF_SHORT = 2L;
    public static final long SIZE_OF_CHAR = 2L;
    public static final long SIZE_OF_INT = 4L;
    public static final long SIZE_OF_LONG = 8L;
    public static final long SIZE_OF_FLOAT = 4L;
    public static final long SIZE_OF_DOUBLE = 8L;
    private static final Unsafe unsafe;
    private long position;
    private long limit;
    private byte[] buffer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public FastByteBuffer() {
        this(1000);
    }

    public FastByteBuffer(byte[] buffer, int limit) {
        AssertUtils.notNull("buffer", buffer);
        if (buffer.length < limit) {
            throw new IllegalArgumentException(String.format("limit %d >= capacity %d", limit, buffer.length));
        }
        this.buffer = buffer;
        this.limit = limit;
        this.position = 0L;
    }

    public FastByteBuffer(int size) {
        AssertUtils.gtEqThanZero("size", size);
        this.buffer = new byte[size];
        this.position = 0L;
        this.limit = this.buffer.length;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public IoBuffer clear() {
        this.position = 0L;
        this.limit = this.capacity();
        return this.getSelf();
    }

    public byte[] elements() {
        return this.buffer;
    }

    @Override
    public IoBuffer ensureAdditionalCapacity(long capacity) {
        if (this.position() + capacity <= (long)this.capacity()) {
            return this.getSelf();
        }
        this.forceCapacity(this.position() + (long)((int)capacity), this.capacity());
        return this.getSelf();
    }

    @Override
    public IoBuffer ensureCapacity(long newCapacity) {
        if (newCapacity <= (long)this.capacity()) {
            return this.getSelf();
        }
        this.forceCapacity(newCapacity, this.capacity());
        return this.getSelf();
    }

    @Override
    public IoBuffer forceCapacity(long length, long preserve) {
        if (length == (long)this.capacity()) {
            return this.getSelf();
        }
        byte[] newBuffer = new byte[(int)length];
        long bytesToCopy = preserve * 1L;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.position = this.position < (long)newBuffer.length ? this.position : (long)(newBuffer.length - 1);
        this.buffer = newBuffer;
        this.limit = this.buffer.length;
        return this.getSelf();
    }

    @Override
    public boolean getBoolean() {
        boolean value = unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        ++this.position;
        return value;
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, long offset, int length) {
        int arraySize = this.getInt();
        boolean[] values = dst == null ? new boolean[arraySize + (int)offset] : dst;
        long bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + offset, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public byte getByte() {
        byte value = unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        ++this.position;
        return value;
    }

    @Override
    public byte[] getByteArray(byte[] dst, long offset, int length) {
        int arraySize = this.getInt();
        byte[] values = dst == null ? new byte[arraySize + (int)offset] : dst;
        long bytesToCopy = dst == null ? arraySize : Math.min(arraySize, length);
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public char getChar() {
        char value = unsafe.getChar(this.buffer, (long)Unsafe.ARRAY_CHAR_BASE_OFFSET + this.position);
        this.position += 2L;
        return value;
    }

    @Override
    public char[] getCharArray(char[] dst, long offset, int length) {
        int arraySize = this.getInt();
        char[] values = dst == null ? new char[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 2L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_SHORT_BASE_OFFSET + offset * 2L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public double getDouble() {
        double value = unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        this.position += 8L;
        return value;
    }

    @Override
    public double[] getDoubleArray(double[] dst, long offset, int length) {
        int arraySize = this.getInt();
        double[] values = dst == null ? new double[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 8L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + offset * 8L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public float getFloat() {
        float value = unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        this.position += 4L;
        return value;
    }

    @Override
    public float[] getFloatArray(float[] dst, long offset, int length) {
        int arraySize = this.getInt();
        float[] values = dst == null ? new float[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 4L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + offset * 4L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public int getInt() {
        int value = unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        this.position += 4L;
        return value;
    }

    @Override
    public int[] getIntArray(int[] dst, long offset, int length) {
        int arraySize = this.getInt();
        int[] values = dst == null ? new int[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 4L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_INT_BASE_OFFSET + offset * 4L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public long getLong() {
        long value = unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        this.position += 8L;
        return value;
    }

    @Override
    public long[] getLongArray(long[] dst, long offset, int length) {
        int arraySize = this.getInt();
        long[] values = dst == null ? new long[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 8L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_LONG_BASE_OFFSET + offset * 8L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    private IoBuffer getSelf() {
        return this;
    }

    @Override
    public short getShort() {
        short value = unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position);
        this.position += 2L;
        return value;
    }

    @Override
    public short[] getShortArray(short[] dst, long offset, int length) {
        int arraySize = this.getInt();
        short[] values = dst == null ? new short[arraySize + (int)offset] : dst;
        long bytesToCopy = (long)(dst == null ? arraySize : Math.min(arraySize, length)) * 2L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, (long)Unsafe.ARRAY_SHORT_BASE_OFFSET + offset * 2L, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public String getString() {
        int arraySize = this.getInt();
        String str = new String(this.buffer, (int)this.position, arraySize - 1, StandardCharsets.ISO_8859_1);
        this.position += (long)arraySize;
        return str;
    }

    @Override
    public String[] getStringArray(String[] dst, long offset, int length) {
        int arraySize = this.getInt();
        String[] ret = dst == null ? new String[arraySize + (int)offset] : dst;
        int size = dst == null ? arraySize : Math.min(arraySize, length);
        for (int k = 0; k < size; ++k) {
            ret[k + (int)offset] = this.getString();
        }
        return ret;
    }

    @Override
    public boolean hasRemaining() {
        return this.position() < (long)this.capacity();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public IoBuffer limit(int newLimit) {
        if (newLimit > this.capacity() || newLimit < 0) {
            throw new IllegalArgumentException(String.format("invalid newLimit: [0, position: %d, newLimit:%d, %d]", this.position, newLimit, this.capacity()));
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this.getSelf();
    }

    @Override
    public ReadWriteLock lock() {
        return this.lock;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public IoBuffer position(long newPosition) {
        if (newPosition > this.limit || newPosition < 0L || newPosition >= (long)this.capacity()) {
            throw new IllegalArgumentException(String.format("invalid newPosition: [0, newPosition=%d, limit:%d, %d]", newPosition, this.limit, this.capacity()));
        }
        this.position = newPosition;
        return this.getSelf();
    }

    @Override
    public IoBuffer putBoolean(boolean value) {
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        ++this.position;
        return this.getSelf();
    }

    @Override
    public IoBuffer putBooleanArray(boolean[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = nElements;
        FastByteBuffer.copyMemory(values, (long)Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + offset, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, bytesToCopy);
        this.position += bytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putByte(byte value) {
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        ++this.position;
        return this.getSelf();
    }

    @Override
    public IoBuffer putByteArray(byte[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = nElements;
        FastByteBuffer.copyMemory(values, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, bytesToCopy);
        this.position += bytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putChar(char value) {
        unsafe.putChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 2L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putCharArray(char[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET;
        long primitiveSize = 2L;
        long nBytesToCopy = (long)nElements * 2L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 2L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putDouble(double value) {
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 8L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putDoubleArray(double[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_DOUBLE_BASE_OFFSET;
        long primitiveSize = 8L;
        long nBytesToCopy = (long)nElements * 8L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 8L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putFloat(float value) {
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 4L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putFloatArray(float[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_FLOAT_BASE_OFFSET;
        long primitiveSize = 4L;
        long nBytesToCopy = (long)nElements * 4L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 4L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putInt(int value) {
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 4L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putIntArray(int[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        long primitiveSize = 4L;
        long nBytesToCopy = (long)nElements * 4L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 4L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putLong(long value) {
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 8L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putLongArray(long[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_LONG_BASE_OFFSET;
        long primitiveSize = 8L;
        long nBytesToCopy = (long)nElements * 8L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 8L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putShort(short value) {
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, value);
        this.position += 2L;
        return this.getSelf();
    }

    @Override
    public IoBuffer putShortArray(short[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long arrayOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET;
        long primitiveSize = 2L;
        long nBytesToCopy = (long)nElements * 2L;
        FastByteBuffer.copyMemory(values, arrayOffset + offset * 2L, this.buffer, arrayOffset + this.position, nBytesToCopy);
        this.position += nBytesToCopy;
        return this.getSelf();
    }

    @Override
    public IoBuffer putString(String string) {
        long initialPos = this.position;
        this.position += 4L;
        int strLength = FastByteBuffer.encodeISO8859(string, this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.position, string.length());
        long endPos = this.position + (long)strLength;
        this.position = initialPos;
        this.putInt(strLength + 1);
        this.position = endPos;
        this.putByte((byte)0);
        return this.getSelf();
    }

    @Override
    public IoBuffer putStringArray(String[] values, long offset, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        for (int k = 0; k < nElements; ++k) {
            this.putString(values[k + (int)offset]);
        }
        return this.getSelf();
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    @Override
    public IoBuffer reset() {
        this.position = 0L;
        this.limit = this.buffer.length;
        return this.getSelf();
    }

    @Override
    public IoBuffer trim() {
        this.trim((int)this.position());
        return this.getSelf();
    }

    @Override
    public IoBuffer trim(int requestedCapacity) {
        if (requestedCapacity >= this.capacity() || this.position() > (long)requestedCapacity) {
            return this.getSelf();
        }
        long bytesToCopy = Math.min(Math.max((long)requestedCapacity, this.position()), (long)this.capacity()) * 1L;
        byte[] newBuffer = new byte[(int)bytesToCopy];
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.buffer = newBuffer;
        this.limit = newBuffer.length;
        return this.getSelf();
    }

    public static void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long nBytes) {
        unsafe.copyMemory(srcBase, srcOffset, destBase, destOffset, nBytes);
    }

    public static FastByteBuffer wrap(byte[] byteArray) {
        return FastByteBuffer.wrap(byteArray, byteArray.length);
    }

    public static FastByteBuffer wrap(byte[] byteArray, int length) {
        return new FastByteBuffer(byteArray, length);
    }

    protected static int encodeISO8859(CharSequence sequence, byte[] bytes, long baseOffset, long offset, int length) {
        if (sequence == null) {
            return 0;
        }
        int utf16Length = sequence.length();
        long j = baseOffset + offset;
        for (int i = 0; i < utf16Length; ++i) {
            unsafe.putByte(bytes, j + (long)i, (byte)(sequence.charAt(i) & 0xFF));
        }
        return utf16Length;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new SecurityException(e);
        }
    }
}

